/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dozer.DozerConfiguration;
import org.apache.camel.component.dozer.DozerEndpoint;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ReflectionHelper;
import org.dozer.config.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DozerComponent.class);

    public DozerComponent() {
        super(DozerEndpoint.class);
        this.initDozerSettings();
    }

    public DozerComponent(CamelContext context) {
        super(context, DozerEndpoint.class);
        this.initDozerSettings();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DozerConfiguration config = new DozerConfiguration();
        config.setName(remaining);
        config.setMappingConfiguration((DozerBeanMapperConfiguration)this.getAndRemoveOrResolveReferenceParameter(parameters, "mappingConfiguration", DozerBeanMapperConfiguration.class));
        this.setProperties(config, parameters);
        if (config.getTargetModel() == null) {
            throw new IllegalArgumentException("The targetModel parameter is required for dozer endpoints");
        }
        return new DozerEndpoint(uri, (Component)this, config);
    }

    private void initDozerSettings() {
        try {
            GlobalSettings settings = GlobalSettings.getInstance();
            LOG.info("Configuring GlobalSettings to enable EL");
            Field field = settings.getClass().getDeclaredField("elEnabled");
            ReflectionHelper.setField((Field)field, (Object)settings, (Object)true);
        }
        catch (NoSuchFieldException nsfEx) {
            throw new IllegalStateException("Failed to enable EL in global Dozer settings", nsfEx);
        }
    }
}

