/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.support.TypeConverterSupport;
import org.dozer.DozerBeanMapper;
import org.dozer.metadata.ClassMappingMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerTypeConverter
extends TypeConverterSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DozerTypeConverter.class);
    private final DozerBeanMapper mapper;

    public DozerTypeConverter(DozerBeanMapper mapper) {
        this.mapper = mapper;
    }

    public DozerBeanMapper getMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
        String mapId = null;
        if (value != null) {
            Class<?> sourceType = value.getClass();
            Class<T> destType = type;
            ClassMappingMetadata metadata = this.mapper.getMappingMetadata().getClassMapping(sourceType, destType);
            if (metadata != null) {
                mapId = metadata.getMapId();
            }
        }
        if (exchange == null) {
            return this.mapper.map(value, type, mapId);
        }
        T answer = null;
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        ClassLoader contextCl = exchange.getContext().getApplicationContextClassLoader();
        if (contextCl != null) {
            LOG.debug("Switching TCCL to: {}.", (Object)contextCl);
            try {
                Thread.currentThread().setContextClassLoader(contextCl);
                answer = this.mapper.map(value, type, mapId);
            }
            finally {
                LOG.debug("Restored TCCL to: {}.", (Object)prev);
                Thread.currentThread().setContextClassLoader(prev);
            }
        } else {
            answer = this.mapper.map(value, type, mapId);
        }
        return answer;
    }
}

