/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.DozerClass;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.RelationshipType;
import org.dozer.converters.CustomConverterContainer;
import org.dozer.fieldmap.FieldMap;
import org.dozer.util.MappingUtils;

public class ClassMap {
    private Configuration globalConfiguration;
    private DozerClass srcClass;
    private DozerClass destClass;
    private List<FieldMap> fieldMaps = new ArrayList<FieldMap>();
    private List<Class<RuntimeException>> allowedExceptions = new ArrayList<Class<RuntimeException>>();
    private MappingDirection type;
    private String dateFormat;
    private String beanFactory;
    private boolean mapNull = true;
    private boolean mapEmptyString = true;
    private Boolean wildcard;
    private Boolean stopOnErrors;
    private Boolean trimStrings;
    private CustomConverterContainer customConverters;
    private String mapId;
    private RelationshipType relationshipType;

    public ClassMap(Configuration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public List<FieldMap> getFieldMaps() {
        return this.fieldMaps;
    }

    public boolean isStopOnErrors() {
        return this.stopOnErrors != null ? this.stopOnErrors.booleanValue() : this.globalConfiguration.getStopOnErrors().booleanValue();
    }

    public void setStopOnErrors(Boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    public boolean isTrimStrings() {
        return this.trimStrings != null ? this.trimStrings.booleanValue() : this.globalConfiguration.getTrimStrings().booleanValue();
    }

    public void setTrimStrings(Boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    public List<Class<RuntimeException>> getAllowedExceptions() {
        if (!this.allowedExceptions.isEmpty()) {
            return this.allowedExceptions;
        }
        return this.globalConfiguration.getAllowedExceptions().getExceptions();
    }

    public void setAllowedExceptions(List<Class<RuntimeException>> allowedExceptions) {
        this.allowedExceptions = allowedExceptions;
    }

    public FieldMap getFieldMapUsingDest(String destFieldName) {
        return this.getFieldMapUsingDest(destFieldName, false);
    }

    public FieldMap getFieldMapUsingDest(String destFieldName, boolean isMap) {
        if (this.fieldMaps == null) {
            return null;
        }
        FieldMap result = null;
        for (FieldMap fieldMap : this.fieldMaps) {
            String fieldName = fieldMap.getDestFieldName();
            if (isMap && MappingUtils.isDeepMapping(fieldName)) {
                fieldName = fieldName.split("\\.")[0];
            }
            String alternateFieldName = this.provideAlternateName(fieldName);
            if (!fieldName.equals(destFieldName) && !alternateFieldName.equals(destFieldName)) continue;
            result = fieldMap;
            break;
        }
        return result;
    }

    String provideAlternateName(String fieldName) {
        return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
    }

    public FieldMap getFieldMapUsingSrc(String srcFieldName) {
        FieldMap result = null;
        if (this.fieldMaps != null) {
            for (FieldMap fieldMap : this.fieldMaps) {
                String fieldName = fieldMap.getSrcFieldName();
                if (fieldName == null || !fieldName.equals(srcFieldName)) continue;
                result = fieldMap;
                break;
            }
        }
        return result;
    }

    public void setFieldMaps(List<FieldMap> fieldMaps) {
        this.fieldMaps = fieldMaps;
    }

    public void addFieldMapping(FieldMap fieldMap) {
        this.fieldMaps.add(fieldMap);
    }

    public void removeFieldMapping(FieldMap fieldMap) {
        this.fieldMaps.remove(fieldMap);
    }

    public boolean isWildcard() {
        return this.wildcard != null ? this.wildcard.booleanValue() : this.globalConfiguration.getWildcard().booleanValue();
    }

    public void setWildcard(Boolean wildcardPolicy) {
        this.wildcard = wildcardPolicy;
    }

    public MappingDirection getType() {
        return this.type;
    }

    public void setType(MappingDirection type) {
        this.type = type;
    }

    public String getDateFormat() {
        return !MappingUtils.isBlankOrNull(this.dateFormat) ? this.dateFormat : this.globalConfiguration.getDateFormat();
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public CustomConverterContainer getCustomConverters() {
        return this.customConverters != null ? this.customConverters : this.globalConfiguration.getCustomConverters();
    }

    public void setCustomConverters(CustomConverterContainer customConverters) {
        this.customConverters = customConverters;
    }

    public Class<?> getSrcClassToMap() {
        return this.srcClass.getClassToMap();
    }

    public Class<?> getDestClassToMap() {
        return this.destClass.getClassToMap();
    }

    public boolean isDestMapNull() {
        return this.destClass.getMapNull() != null ? this.destClass.getMapNull() : this.mapNull;
    }

    public boolean isSrcMapNull() {
        return this.srcClass.getMapNull() != null ? this.srcClass.getMapNull() : this.mapNull;
    }

    public boolean isDestMapEmptyString() {
        return this.destClass.getMapEmptyString() != null ? this.destClass.getMapEmptyString() : this.mapEmptyString;
    }

    public boolean isSrcMapEmptyString() {
        return this.srcClass.getMapEmptyString() != null ? this.srcClass.getMapEmptyString() : this.mapEmptyString;
    }

    public String getDestClassBeanFactory() {
        return !MappingUtils.isBlankOrNull(this.destClass.getBeanFactory()) ? this.destClass.getBeanFactory() : this.getBeanFactory();
    }

    public String getSrcClassBeanFactory() {
        return !MappingUtils.isBlankOrNull(this.srcClass.getBeanFactory()) ? this.srcClass.getBeanFactory() : this.getBeanFactory();
    }

    public String getDestClassBeanFactoryId() {
        return this.destClass.getFactoryBeanId();
    }

    public String getSrcClassBeanFactoryId() {
        return this.srcClass.getFactoryBeanId();
    }

    public String getSrcClassMapGetMethod() {
        return this.srcClass.getMapGetMethod();
    }

    public String getSrcClassMapSetMethod() {
        return this.srcClass.getMapSetMethod();
    }

    public String getDestClassMapGetMethod() {
        return this.destClass.getMapGetMethod();
    }

    public String getDestClassMapSetMethod() {
        return this.destClass.getMapSetMethod();
    }

    public String getDestClassCreateMethod() {
        return this.destClass.getCreateMethod();
    }

    public String getSrcClassCreateMethod() {
        return this.srcClass.getCreateMethod();
    }

    public void setSrcClassCreateMethod(String createMethod) {
        this.srcClass.setCreateMethod(createMethod);
    }

    public void setDestClassCreateMethod(String createMethod) {
        this.destClass.setCreateMethod(createMethod);
    }

    public boolean isDestClassMapTypeCustomGetterSetter() {
        return this.destClass.isMapTypeCustomGetterSetterClass();
    }

    public boolean isSrcClassMapTypeCustomGetterSetter() {
        return this.srcClass.isMapTypeCustomGetterSetterClass();
    }

    public void setSrcClass(DozerClass srcClass) {
        this.srcClass = srcClass;
    }

    public void setDestClass(DozerClass destClass) {
        this.destClass = destClass;
    }

    public String getDestClassName() {
        return this.destClass.getName();
    }

    public String getSrcClassName() {
        return this.srcClass.getName();
    }

    public String getBeanFactory() {
        return !MappingUtils.isBlankOrNull(this.beanFactory) ? this.beanFactory : this.globalConfiguration.getBeanFactory();
    }

    public void setBeanFactory(String beanFactory) {
        this.beanFactory = beanFactory;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public void setMapNull(boolean mapNull) {
        this.mapNull = mapNull;
    }

    public void setMapEmptyString(boolean mapEmptyString) {
        this.mapEmptyString = mapEmptyString;
    }

    public Configuration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(Configuration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType != null ? this.relationshipType : this.globalConfiguration.getRelationshipType();
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public DozerClass getSrcClass() {
        return this.srcClass;
    }

    public DozerClass getDestClass() {
        return this.destClass;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("source class", this.getSrcClassName()).append("destination class", this.getDestClassName()).append("map-id", this.mapId).toString();
    }
}

