/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public class ELEngine {
    private final ExpressionFactory factory = ExpressionFactory.newInstance();
    private final CompositeELResolver resolver = new CompositeELResolver();
    private ELContext context;

    public ELEngine() {
        this.resolver.add(new ArrayELResolver());
        this.resolver.add(new ListELResolver());
        this.resolver.add(new MapELResolver());
        this.resolver.add(new BeanELResolver());
    }

    public void init() {
        this.context = new SimpleContext(this.resolver);
    }

    public <T> void setVariable(String key, T value) {
        this.setVariable(key, value, value.getClass());
    }

    public <T> void setVariable(String key, T value, Class<? extends T> type) {
        VariableMapper variableMapper = this.context.getVariableMapper();
        ValueExpression valueExpression = this.factory.createValueExpression(value, type);
        variableMapper.setVariable(key, valueExpression);
    }

    public void setFunction(String prefix, Method method) {
        Functions functions = (Functions)this.context.getFunctionMapper();
        functions.setFunction(prefix, method.getName(), method);
    }

    public void setFunction(String prefix, String name, Method method) {
        Functions functions = (Functions)this.context.getFunctionMapper();
        functions.setFunction(prefix, name, method);
    }

    public String resolve(String expression) {
        ValueExpression expr = this.factory.createValueExpression(this.context, expression, String.class);
        return (String)expr.getValue(this.context);
    }

    static class Variables
    extends VariableMapper {
        final Map<String, ValueExpression> map = new HashMap<String, ValueExpression>();

        Variables() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            return this.map.get(variable);
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            return this.map.put(variable, expression);
        }
    }

    static class Functions
    extends FunctionMapper {
        final Map<String, Method> map = new HashMap<String, Method>();

        Functions() {
        }

        @Override
        public Method resolveFunction(String prefix, String localName) {
            return this.map.get(prefix + ":" + localName);
        }

        public void setFunction(String prefix, String localName, Method method) {
            this.map.put(prefix + ":" + localName, method);
        }
    }

    static class SimpleContext
    extends ELContext {
        private Functions functions = new Functions();
        private Variables variables = new Variables();
        private ELResolver resolver;

        SimpleContext(ELResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public ELResolver getELResolver() {
            return this.resolver;
        }

        @Override
        public FunctionMapper getFunctionMapper() {
            return this.functions;
        }

        @Override
        public VariableMapper getVariableMapper() {
            return this.variables;
        }
    }
}

