/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerThreadContextClassLoader
implements DozerClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DozerThreadContextClassLoader.class);

    @Override
    public Class<?> loadClass(String className) {
        LOG.debug("Loading class from classloader: {}.", (Object)Thread.currentThread().getContextClassLoader());
        Class<?> result = null;
        try {
            result = ClassUtils.getClass(Thread.currentThread().getContextClassLoader(), className);
        }
        catch (ClassNotFoundException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    @Override
    public URL loadResource(String uri) {
        URL answer = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            LOG.debug("Loading resource from classloader: {}.", (Object)cl);
            answer = cl.getResource(uri);
        }
        if (answer == null) {
            answer = ClassLoader.getSystemResource(uri);
        }
        if (answer == null && StringUtils.contains((CharSequence)uri, ":")) {
            try {
                answer = new URL(uri);
            }
            catch (MalformedURLException e) {
                MappingUtils.throwMappingException(e);
            }
        }
        return answer;
    }
}

