/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import org.apache.commons.lang3.ClassUtils;
import org.dozer.ConfigurableCustomConverter;
import org.dozer.MappingException;

public abstract class DozerConverter<A, B>
implements ConfigurableCustomConverter {
    private String parameter;
    private Class<A> prototypeA;
    private Class<B> prototypeB;

    public DozerConverter(Class<A> prototypeA, Class<B> prototypeB) {
        this.prototypeA = prototypeA;
        this.prototypeB = prototypeB;
    }

    @Override
    public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
        Class<?> wrappedDestinationClass = ClassUtils.primitiveToWrapper(destinationClass);
        Class<?> wrappedSourceClass = ClassUtils.primitiveToWrapper(sourceClass);
        if (this.prototypeA.equals(wrappedDestinationClass)) {
            return this.convertFrom(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeB.equals(wrappedDestinationClass)) {
            return this.convertTo(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeA.equals(wrappedSourceClass)) {
            return this.convertTo(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeB.equals(wrappedSourceClass)) {
            return this.convertFrom(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeA.isAssignableFrom(wrappedDestinationClass)) {
            return this.convertFrom(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeB.isAssignableFrom(wrappedDestinationClass)) {
            return this.convertTo(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeA.isAssignableFrom(wrappedSourceClass)) {
            return this.convertTo(sourceFieldValue, existingDestinationFieldValue);
        }
        if (this.prototypeB.isAssignableFrom(wrappedSourceClass)) {
            return this.convertFrom(sourceFieldValue, existingDestinationFieldValue);
        }
        throw new MappingException("Destination Type (" + wrappedDestinationClass.getName() + ") is not accepted by this Custom Converter (" + this.getClass().getName() + ")!");
    }

    public abstract B convertTo(A var1, B var2);

    public B convertTo(A source) {
        return this.convertTo(source, null);
    }

    public abstract A convertFrom(B var1, A var2);

    public A convertFrom(B source) {
        return this.convertFrom(source, null);
    }

    @Override
    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getParameter() {
        if (this.parameter == null) {
            throw new IllegalStateException("Custom Converter Parameter has not yet been set!");
        }
        return this.parameter;
    }
}

