/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dozer.DozerConfiguration;
import org.apache.camel.component.dozer.DozerEndpoint;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerThreadContextClassLoader;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ReflectionHelper;
import org.dozer.DozerBeanMapper;
import org.dozer.config.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DozerComponent.class);

    public DozerComponent() {
        super(DozerEndpoint.class);
    }

    public DozerComponent(CamelContext context) {
        super(context, DozerEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DozerConfiguration config = new DozerConfiguration();
        config.setName(remaining);
        config.setMappingConfiguration((DozerBeanMapperConfiguration)this.getAndRemoveOrResolveReferenceParameter(parameters, "mappingConfiguration", DozerBeanMapperConfiguration.class));
        this.setProperties(config, parameters);
        if (config.getTargetModel() == null) {
            throw new IllegalArgumentException("The targetModel parameter is required for dozer endpoints");
        }
        return new DozerEndpoint(uri, (Component)this, config);
    }

    public static DozerBeanMapper createDozerBeanMapper(List<String> mappingFiles) {
        Field field;
        GlobalSettings settings = GlobalSettings.getInstance();
        try {
            LOG.info("Configuring GlobalSettings to use Camel classloader: {}", (Object)DozerThreadContextClassLoader.class.getName());
            field = settings.getClass().getDeclaredField("classLoaderBeanName");
            ReflectionHelper.setField((Field)field, (Object)settings, (Object)DozerThreadContextClassLoader.class.getName());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot configure Dozer GlobalSettings to use DozerThreadContextClassLoader as classloader due " + e.getMessage(), e);
        }
        try {
            LOG.info("Configuring GlobalSettings to enable EL");
            field = settings.getClass().getDeclaredField("elEnabled");
            ReflectionHelper.setField((Field)field, (Object)settings, (Object)true);
        }
        catch (NoSuchFieldException nsfEx) {
            throw new IllegalStateException("Failed to enable EL in global Dozer settings", nsfEx);
        }
        return new DozerBeanMapper(mappingFiles);
    }
}

