/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dozer.CustomMapper;
import org.apache.camel.component.dozer.DozerConfiguration;
import org.apache.camel.component.dozer.DozerProducer;
import org.apache.camel.component.dozer.ExpressionMapper;
import org.apache.camel.component.dozer.VariableMapper;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.MapperFactory;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ResourceHelper;
import org.dozer.CustomConverter;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.15.0", scheme="dozer", title="Dozer", syntax="dozer:name", producerOnly=true, label="transformation")
public class DozerEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DozerEndpoint.class);
    private static final String CUSTOM_MAPPING_ID = "_customMapping";
    private static final String VARIABLE_MAPPING_ID = "_variableMapping";
    private static final String EXPRESSION_MAPPING_ID = "_expressionMapping";
    private Mapper mapper;
    private VariableMapper variableMapper;
    private CustomMapper customMapper;
    private ExpressionMapper expressionMapper;
    @UriParam
    private DozerConfiguration configuration;

    public DozerEndpoint(String endpointUri, Component component, DozerConfiguration configuration) throws Exception {
        super(endpointUri, component);
        this.configuration = configuration;
        this.variableMapper = new VariableMapper();
        this.customMapper = new CustomMapper(this.getCamelContext().getClassResolver());
        this.expressionMapper = new ExpressionMapper();
    }

    public Producer createProducer() throws Exception {
        return new DozerProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Dozer endpoints");
    }

    public boolean isSingleton() {
        return true;
    }

    public Mapper getMapper() throws Exception {
        return this.mapper;
    }

    public DozerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DozerConfiguration configuration) {
        this.configuration = configuration;
    }

    CustomMapper getCustomMapper() {
        return this.customMapper;
    }

    VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    ExpressionMapper getExpressionMapper() {
        return this.expressionMapper;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.initDozerBeanContainerAndMapper();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected void initDozerBeanContainerAndMapper() throws Exception {
        LOG.info("Configuring {}...", (Object)Mapper.class.getName());
        if (this.mapper == null) {
            if (this.configuration.getMappingConfiguration() == null) {
                URL url = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.configuration.getMappingFile());
                DozerBeanMapperConfiguration config = new DozerBeanMapperConfiguration();
                config.setCustomConvertersWithId(this.getCustomConvertersWithId());
                config.setMappingFiles(Arrays.asList(url.toString()));
                this.configuration.setMappingConfiguration(config);
            } else {
                DozerBeanMapperConfiguration config = this.configuration.getMappingConfiguration();
                if (config.getCustomConvertersWithId() == null) {
                    config.setCustomConvertersWithId(this.getCustomConvertersWithId());
                } else {
                    config.getCustomConvertersWithId().putAll(this.getCustomConvertersWithId());
                }
                if (config.getMappingFiles() == null || config.getMappingFiles().size() <= 0) {
                    URL url = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.configuration.getMappingFile());
                    config.setMappingFiles(Arrays.asList(url.toString()));
                }
            }
            MapperFactory factory = new MapperFactory(this.getCamelContext(), this.configuration.getMappingConfiguration());
            this.mapper = factory.create();
        }
    }

    private Map<String, CustomConverter> getCustomConvertersWithId() {
        HashMap<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>();
        customConvertersWithId.put(CUSTOM_MAPPING_ID, this.customMapper);
        customConvertersWithId.put(VARIABLE_MAPPING_ID, this.variableMapper);
        customConvertersWithId.put(EXPRESSION_MAPPING_ID, this.expressionMapper);
        return customConvertersWithId;
    }
}

