/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.generator.BeanFieldsDetector;
import org.dozer.classmap.generator.GeneratorUtils;
import org.dozer.classmap.generator.JavaBeanFieldsDetector;
import org.dozer.classmap.generator.MappingType;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.CollectionUtils;

public class BeanMappingGenerator
implements ClassMapBuilder.ClassMappingGenerator {
    final List<BeanFieldsDetector> pluggedFieldDetectors = new ArrayList<BeanFieldsDetector>();
    final List<BeanFieldsDetector> availableFieldDetectors = new ArrayList<BeanFieldsDetector>(){
        {
            this.add(new JavaBeanFieldsDetector());
        }
    };
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public BeanMappingGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    @Override
    public boolean accepts(ClassMap classMap) {
        return true;
    }

    @Override
    public boolean apply(ClassMap classMap, Configuration configuration) {
        Class<?> srcClass = classMap.getSrcClassToMap();
        Class<?> destClass = classMap.getDestClassToMap();
        Set<String> destFieldNames = this.getAcceptsFieldsDetector(destClass).getWritableFieldNames(destClass);
        Set<String> srcFieldNames = this.getAcceptsFieldsDetector(srcClass).getReadableFieldNames(srcClass);
        Set<String> commonFieldNames = CollectionUtils.intersection(srcFieldNames, destFieldNames);
        for (String fieldName : commonFieldNames) {
            if (GeneratorUtils.shouldIgnoreField(fieldName, srcClass, destClass, this.beanContainer) || classMap.getFieldMapUsingDest(fieldName) != null || classMap.getFieldMapUsingSrc(fieldName) != null) continue;
            GeneratorUtils.addGenericMapping(MappingType.GETTER_TO_SETTER, classMap, configuration, fieldName, fieldName, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        }
        return false;
    }

    private BeanFieldsDetector getAcceptsFieldsDetector(Class<?> clazz) {
        BeanFieldsDetector detector = this.getAcceptsFieldDetector(clazz, this.pluggedFieldDetectors);
        if (detector == null) {
            detector = this.getAcceptsFieldDetector(clazz, this.availableFieldDetectors);
        }
        return detector;
    }

    private BeanFieldsDetector getAcceptsFieldDetector(Class<?> clazz, List<BeanFieldsDetector> detectors) {
        for (BeanFieldsDetector detector : new CopyOnWriteArrayList<BeanFieldsDetector>(detectors)) {
            if (!detector.accepts(clazz)) continue;
            return detector;
        }
        return null;
    }

    public void addPluggedFieldDetectors(Collection<BeanFieldsDetector> beanFieldsDetectors) {
        this.pluggedFieldDetectors.addAll(beanFieldsDetectors);
    }
}

