/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap.generator;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.generator.GeneratorUtils;
import org.dozer.classmap.generator.JavaBeanFieldsDetector;
import org.dozer.classmap.generator.MappingType;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.FieldMap;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.CollectionUtils;

public class ClassLevelFieldMappingGenerator
implements ClassMapBuilder.ClassMappingGenerator {
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public ClassLevelFieldMappingGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    @Override
    public boolean accepts(ClassMap classMap) {
        return this.srcClassIsAccessible(classMap) || this.destClassIsAccessible(classMap);
    }

    @Override
    public boolean apply(ClassMap classMap, Configuration configuration) {
        JavaBeanFieldsDetector beanFieldsDetector = new JavaBeanFieldsDetector();
        Set<String> destFieldNames = this.getDeclaredFieldNames(classMap.getDestClassToMap());
        Set<String> destWritablePropertyNames = beanFieldsDetector.getWritableFieldNames(classMap.getDestClassToMap());
        Set<String> srcFieldNames = this.getDeclaredFieldNames(classMap.getSrcClassToMap());
        Set<String> srcReadablePropertyNames = beanFieldsDetector.getReadableFieldNames(classMap.getSrcClassToMap());
        Set<String> matchingUnmappedFields = this.getMatchingUnmappedFieldNames(classMap.getFieldMaps(), srcFieldNames, destFieldNames);
        for (String mutualFieldName : matchingUnmappedFields) {
            this.mapFieldAppropriately(classMap, configuration, mutualFieldName, destWritablePropertyNames, srcReadablePropertyNames);
        }
        return false;
    }

    private void mapFieldAppropriately(ClassMap classMap, Configuration configuration, String mutualFieldName, Set<String> destWritablePropertyNames, Set<String> srcReadablePropertyNames) {
        MappingType mappingType = !this.destClassIsAccessible(classMap) && destWritablePropertyNames.contains(mutualFieldName) ? MappingType.FIELD_TO_SETTER : (!this.srcClassIsAccessible(classMap) && srcReadablePropertyNames.contains(mutualFieldName) ? MappingType.GETTER_TO_FIELD : MappingType.FIELD_TO_FIELD);
        GeneratorUtils.addGenericMapping(mappingType, classMap, configuration, mutualFieldName, mutualFieldName, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
    }

    private Set<String> getDeclaredFieldNames(Class<?> srcType) {
        HashSet<String> declaredFieldNames = new HashSet<String>();
        do {
            for (Field field : srcType.getDeclaredFields()) {
                declaredFieldNames.add(field.getName());
            }
        } while ((srcType = srcType.getSuperclass()) != null);
        return declaredFieldNames;
    }

    private Set<String> getMatchingUnmappedFieldNames(List<FieldMap> fieldMaps, Set<String> srcFieldNames, Set<String> destFieldNames) {
        for (FieldMap fieldMap : fieldMaps) {
            srcFieldNames.remove(fieldMap.getSrcFieldName());
            destFieldNames.remove(fieldMap.getDestFieldName());
        }
        return new HashSet<String>(CollectionUtils.intersection(srcFieldNames, destFieldNames));
    }

    private boolean destClassIsAccessible(ClassMap classMap) {
        return classMap.getDestClass() != null && classMap.getDestClass().isAccessible();
    }

    private boolean srcClassIsAccessible(ClassMap classMap) {
        return classMap.getSrcClass() != null && classMap.getSrcClass().isAccessible();
    }
}

