/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.dozer.converters.ConversionException;

public class CalendarConverter
implements Converter {
    private DateFormat dateFormat;

    public CalendarConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Object convert(Class destClass, Object srcObj) {
        GregorianCalendar result = new GregorianCalendar();
        Class<?> srcFieldClass = srcObj.getClass();
        if (Date.class.isAssignableFrom(srcFieldClass)) {
            result.setTime((Date)srcObj);
        } else if (Calendar.class.isAssignableFrom(srcFieldClass)) {
            Calendar c = (Calendar)srcObj;
            result.setTime(c.getTime());
            ((Calendar)result).setTimeZone(c.getTimeZone());
        } else if (XMLGregorianCalendar.class.isAssignableFrom(srcFieldClass)) {
            GregorianCalendar c = ((XMLGregorianCalendar)srcObj).toGregorianCalendar();
            result.setTime(c.getTime());
            ((Calendar)result).setTimeZone(((Calendar)c).getTimeZone());
        } else {
            if (this.dateFormat != null && String.class.isAssignableFrom(srcFieldClass)) {
                try {
                    result.setTime(new Date(this.dateFormat.parse((String)srcObj).getTime()));
                }
                catch (ParseException e) {
                    throw new ConversionException("Unable to parse source object using specified date format", e);
                }
            }
            try {
                result.setTime(new Date(Long.parseLong(srcObj.toString())));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to determine time in millis of source object", e);
            }
        }
        if (this.dateFormat != null && String.class.isAssignableFrom(destClass)) {
            return this.dateFormat.format(result.getTime());
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }
}

