/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dozer.BeanFactory;
import org.dozer.MappingException;
import org.dozer.config.BeanContainer;
import org.dozer.converters.JAXBElementConverter;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.BeanCreationStrategy;
import org.dozer.factory.JAXBBeanFactory;
import org.dozer.factory.XMLBeanFactory;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstructionStrategies {
    private final BeanCreationStrategy byCreateMethod;
    private final BeanCreationStrategy byGetInstance;
    private final BeanCreationStrategy byInterface;
    private final BeanCreationStrategy xmlBeansBased;
    private final BeanCreationStrategy jaxbBeansBased;
    private final BeanCreationStrategy constructorBased;
    private final ByFactory byFactory;
    private final BeanCreationStrategy xmlGregorianCalendar;

    public ConstructionStrategies(BeanContainer beanContainer) {
        this.byCreateMethod = new ByCreateMethod(beanContainer);
        this.byGetInstance = new ByGetInstance(beanContainer);
        this.byInterface = new ByInterface();
        this.xmlBeansBased = new XMLBeansBased(beanContainer);
        this.jaxbBeansBased = new JAXBBeansBased(beanContainer);
        this.constructorBased = new ByConstructor();
        this.byFactory = new ByFactory(beanContainer);
        this.xmlGregorianCalendar = new XmlGregorian();
    }

    public BeanCreationStrategy byCreateMethod() {
        return this.byCreateMethod;
    }

    public BeanCreationStrategy byGetInstance() {
        return this.byGetInstance;
    }

    public BeanCreationStrategy byInterface() {
        return this.byInterface;
    }

    public BeanCreationStrategy xmlBeansBased() {
        return this.xmlBeansBased;
    }

    public BeanCreationStrategy jaxbBeansBased() {
        return this.jaxbBeansBased;
    }

    public BeanCreationStrategy byConstructor() {
        return this.constructorBased;
    }

    public ByFactory byFactory() {
        return this.byFactory;
    }

    public BeanCreationStrategy xmlGregorianCalendar() {
        return this.xmlGregorianCalendar;
    }

    private static class XmlGregorian
    implements BeanCreationStrategy {
        private XmlGregorian() {
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            return XMLGregorianCalendar.class.isAssignableFrom(actualClass);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            DatatypeFactory dataTypeFactory;
            try {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new MappingException(e);
            }
            return dataTypeFactory.newXMLGregorianCalendar();
        }
    }

    static class ByConstructor
    implements BeanCreationStrategy {
        ByConstructor() {
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            return true;
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Class<?> classToCreate = directive.getActualClass();
            try {
                return ByConstructor.newInstance(classToCreate);
            }
            catch (Exception e) {
                if (directive.getAlternateClass() != null) {
                    return ByConstructor.newInstance(directive.getAlternateClass());
                }
                MappingUtils.throwMappingException(e);
                return null;
            }
        }

        private static <T> T newInstance(Class<T> clazz) {
            Constructor<T> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(null);
            }
            catch (SecurityException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (NoSuchMethodException e) {
                MappingUtils.throwMappingException(e);
            }
            if (constructor == null) {
                MappingUtils.throwMappingException("Could not create a new instance of the dest object: " + clazz + ".  Could not find a no-arg constructor for this class.");
            }
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            T result = null;
            try {
                result = constructor.newInstance(null);
            }
            catch (IllegalArgumentException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (InstantiationException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (IllegalAccessException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (InvocationTargetException e) {
                MappingUtils.throwMappingException(e);
            }
            return result;
        }
    }

    static class JAXBBeansBased
    implements BeanCreationStrategy {
        final BeanFactory jaxbBeanFactory;
        boolean jaxbBeansAvailable;
        private Class<?> jaxbObjectType;
        private final BeanContainer beanContainer;

        JAXBBeansBased(BeanContainer beanContainer) {
            this(new JAXBBeanFactory(), beanContainer);
        }

        JAXBBeansBased(JAXBBeanFactory jaxbBeanFactory, BeanContainer beanContainer) {
            this.jaxbBeanFactory = jaxbBeanFactory;
            this.beanContainer = beanContainer;
            try {
                this.jaxbObjectType = Class.forName("javax.xml.bind.JAXBElement");
                this.jaxbBeansAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.jaxbBeansAvailable = false;
            }
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            if (!this.jaxbBeansAvailable) {
                return false;
            }
            Class<?> actualClass = directive.getActualClass();
            return this.jaxbObjectType.isAssignableFrom(actualClass);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            JAXBElementConverter jaxbElementConverter = new JAXBElementConverter(directive.getDestObj() != null ? directive.getDestObj().getClass().getCanonicalName() : directive.getActualClass().getCanonicalName(), directive.getFieldName(), null, this.beanContainer);
            String beanId = jaxbElementConverter.getBeanId();
            Object destValue = this.jaxbBeanFactory.createBean(directive.getSrcObject(), directive.getSrcClass(), beanId, this.beanContainer);
            return jaxbElementConverter.convert((Class)this.jaxbObjectType, destValue != null ? destValue : directive.getSrcObject());
        }
    }

    static class XMLBeansBased
    implements BeanCreationStrategy {
        final BeanFactory xmlBeanFactory;
        boolean xmlBeansAvailable;
        private Class<?> xmlObjectType;
        private final BeanContainer beanContainer;

        XMLBeansBased(BeanContainer beanContainer) {
            this(new XMLBeanFactory(), beanContainer);
        }

        XMLBeansBased(XMLBeanFactory xmlBeanFactory, BeanContainer beanContainer) {
            this.xmlBeanFactory = xmlBeanFactory;
            this.beanContainer = beanContainer;
            try {
                this.xmlObjectType = Class.forName("org.apache.xmlbeans.XmlObject");
                this.xmlBeansAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.xmlBeansAvailable = false;
            }
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            if (!this.xmlBeansAvailable) {
                return false;
            }
            Class<?> actualClass = directive.getActualClass();
            return this.xmlObjectType.isAssignableFrom(actualClass);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Class<?> classToCreate = directive.getActualClass();
            String factoryBeanId = directive.getFactoryId();
            String beanId = !MappingUtils.isBlankOrNull(factoryBeanId) ? factoryBeanId : classToCreate.getName();
            return this.xmlBeanFactory.createBean(directive.getSrcObject(), directive.getSrcClass(), beanId, this.beanContainer);
        }
    }

    static class ByInterface
    implements BeanCreationStrategy {
        ByInterface() {
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            return Map.class.equals(actualClass) || List.class.equals(actualClass) || Set.class.equals(actualClass);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            if (Map.class.equals(actualClass)) {
                return new HashMap();
            }
            if (List.class.equals(actualClass)) {
                return new ArrayList();
            }
            if (Set.class.equals(actualClass)) {
                return new HashSet();
            }
            throw new IllegalStateException("Type not expected : " + actualClass);
        }
    }

    static class ByFactory
    implements BeanCreationStrategy {
        private final Logger log = LoggerFactory.getLogger(ByFactory.class);
        private final ConcurrentMap<String, BeanFactory> factoryCache = new ConcurrentHashMap<String, BeanFactory>();
        private final BeanContainer beanContainer;

        ByFactory(BeanContainer beanContainer) {
            this.beanContainer = beanContainer;
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            String factoryName = directive.getFactoryName();
            return !MappingUtils.isBlankOrNull(factoryName);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Class<?> classToCreate = directive.getActualClass();
            String factoryName = directive.getFactoryName();
            String factoryBeanId = directive.getFactoryId();
            String beanId = !MappingUtils.isBlankOrNull(factoryBeanId) ? factoryBeanId : classToCreate.getName();
            BeanFactory factory = (BeanFactory)this.factoryCache.get(factoryName);
            if (factory == null) {
                Class<?> factoryClass = MappingUtils.loadClass(factoryName, this.beanContainer);
                if (!BeanFactory.class.isAssignableFrom(factoryClass)) {
                    MappingUtils.throwMappingException("Custom bean factory must implement " + BeanFactory.class.getName() + " interface : " + factoryClass);
                }
                factory = (BeanFactory)ReflectionUtils.newInstance(factoryClass);
                this.factoryCache.put(factoryName, factory);
            }
            Object result = factory.createBean(directive.getSrcObject(), directive.getSrcClass(), beanId, this.beanContainer);
            this.log.debug("Bean instance created with custom factory -->\n  Bean Type: {}\n  Factory Name: {}", (Object)result.getClass().getName(), (Object)factoryName);
            if (!classToCreate.isAssignableFrom(result.getClass())) {
                MappingUtils.throwMappingException("Custom bean factory (" + factory.getClass() + ") did not return correct type of destination data object. Expected : " + classToCreate + ", Actual : " + result.getClass());
            }
            return result;
        }

        public void setStoredFactories(Map<String, BeanFactory> factories) {
            this.factoryCache.putAll(factories);
        }
    }

    static class ByGetInstance
    extends ByCreateMethod {
        ByGetInstance(BeanContainer beanContainer) {
            super(beanContainer);
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            return Calendar.class.isAssignableFrom(actualClass) || DateFormat.class.isAssignableFrom(actualClass);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            directive.setCreateMethod("getInstance");
            return super.create(directive);
        }
    }

    static class ByCreateMethod
    implements BeanCreationStrategy {
        private final BeanContainer beanContainer;

        ByCreateMethod(BeanContainer beanContainer) {
            this.beanContainer = beanContainer;
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            String createMethod = directive.getCreateMethod();
            return !MappingUtils.isBlankOrNull(createMethod);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Method method;
            Class<?> actualClass = directive.getActualClass();
            String createMethod = directive.getCreateMethod();
            if (createMethod.contains(".")) {
                String methodName = createMethod.substring(createMethod.lastIndexOf(".") + 1, createMethod.length());
                String typeName = createMethod.substring(0, createMethod.lastIndexOf("."));
                DozerClassLoader loader = this.beanContainer.getClassLoader();
                Class<?> type = loader.loadClass(typeName);
                method = this.findMethod(type, methodName);
            } else {
                method = this.findMethod(actualClass, createMethod);
            }
            return ReflectionUtils.invoke(method, null, null);
        }

        private Method findMethod(Class<?> actualClass, String createMethod) {
            Method method = null;
            try {
                method = ReflectionUtils.getMethod(actualClass, createMethod, null);
            }
            catch (NoSuchMethodException e) {
                MappingUtils.throwMappingException(e);
            }
            return method;
        }
    }
}

