/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.fieldmap;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dozer.BeanBuilder;
import org.dozer.MappingException;
import org.dozer.builder.BuilderUtil;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.DozerClass;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.RelationshipType;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.propertydescriptor.GetterSetterPropertyDescriptor;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldMap
implements Cloneable {
    private final Logger log = LoggerFactory.getLogger(FieldMap.class);
    protected final BeanContainer beanContainer;
    protected final DestBeanCreator destBeanCreator;
    protected final PropertyDescriptorFactory propertyDescriptorFactory;
    private ClassMap classMap;
    private DozerField srcField;
    private DozerField destField;
    private HintContainer srcHintContainer;
    private HintContainer destHintContainer;
    private HintContainer srcDeepIndexHintContainer;
    private HintContainer destDeepIndexHintContainer;
    private MappingDirection type;
    private boolean copyByReference;
    private boolean copyByReferenceOveridden;
    private String mapId;
    private String customConverter;
    private String customConverterId;
    private String customConverterParam;
    private RelationshipType relationshipType;
    private boolean removeOrphans;
    private final ConcurrentMap<Class<?>, DozerPropertyDescriptor> srcPropertyDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, DozerPropertyDescriptor> destPropertyDescriptorMap = new ConcurrentHashMap();

    public FieldMap(ClassMap classMap, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.classMap = classMap;
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    public ClassMap getClassMap() {
        return this.classMap;
    }

    public void setClassMap(ClassMap classMap) {
        this.classMap = classMap;
    }

    public Object getSrcFieldValue(Object runtimeSrcObj) {
        return this.getSrcPropertyDescriptor(runtimeSrcObj.getClass()).getPropertyValue(runtimeSrcObj);
    }

    public void writeDestValue(Object runtimeDestObj, Object destFieldValue) {
        if (this.log.isDebugEnabled()) {
            String className = MappingUtils.getClassNameWithoutPackage(runtimeDestObj.getClass());
            this.log.debug("Getting ready to invoke write method on the destination object. Dest Obj: {}, Dest value: {}", (Object)className, destFieldValue);
        }
        DozerPropertyDescriptor propDescriptor = this.getDestPropertyDescriptor(BuilderUtil.unwrapDestClassFromBuilder(runtimeDestObj));
        propDescriptor.setPropertyValue(runtimeDestObj, destFieldValue, this);
    }

    public Class<?> getDestHintType(Class<?> runtimeSrcClass) {
        if (this.getDestHintContainer() != null) {
            if (this.getSrcHintContainer() != null) {
                return this.getDestHintContainer().getHint(runtimeSrcClass, this.getSrcHintContainer().getHints());
            }
            return this.getDestHintContainer().getHint();
        }
        return runtimeSrcClass;
    }

    public Class<?> getDestFieldType(Class<?> runtimeDestClass) {
        Class<?> result = null;
        if (this.isDestFieldIndexed()) {
            Class<?> clazz = result = this.destHintContainer != null ? this.destHintContainer.getHint() : null;
        }
        if (result == null) {
            result = this.getDestPropertyDescriptor(runtimeDestClass).getPropertyType();
        }
        return result;
    }

    public Class<?> getSrcFieldType(Class<?> runtimeSrcClass) {
        return this.getSrcPropertyDescriptor(runtimeSrcClass).getPropertyType();
    }

    @Deprecated
    public Class<?> getDestFieldWriteMethodParameter(Class<?> runtimeDestClass) {
        DozerPropertyDescriptor dpd = this.getDestPropertyDescriptor(runtimeDestClass);
        return ((GetterSetterPropertyDescriptor)dpd).getWriteMethodPropertyType();
    }

    public Class<?> getGenericType(Class<?> runtimeDestClass) {
        DozerPropertyDescriptor propertyDescriptor = this.getDestPropertyDescriptor(runtimeDestClass);
        return propertyDescriptor.genericType();
    }

    public Object getDestValue(Object runtimeDestObj) {
        return this.getDestPropertyDescriptor(BuilderUtil.unwrapDestClassFromBuilder(runtimeDestObj)).getPropertyValue(runtimeDestObj);
    }

    public HintContainer getDestHintContainer() {
        return this.destHintContainer;
    }

    public void setDestHintContainer(HintContainer destHint) {
        this.destHintContainer = destHint;
    }

    public HintContainer getSrcHintContainer() {
        return this.srcHintContainer;
    }

    public void setSrcHintContainer(HintContainer sourceHint) {
        this.srcHintContainer = sourceHint;
    }

    public String getSrcFieldMapGetMethod() {
        return !MappingUtils.isBlankOrNull(this.srcField.getMapGetMethod()) ? this.srcField.getMapGetMethod() : this.classMap.getSrcClassMapGetMethod();
    }

    public String getSrcFieldMapSetMethod() {
        return !MappingUtils.isBlankOrNull(this.srcField.getMapSetMethod()) ? this.srcField.getMapSetMethod() : this.classMap.getSrcClassMapSetMethod();
    }

    public String getDestFieldMapGetMethod() {
        return !MappingUtils.isBlankOrNull(this.destField.getMapGetMethod()) ? this.destField.getMapGetMethod() : this.classMap.getDestClassMapGetMethod();
    }

    public String getDestFieldMapSetMethod() {
        return !MappingUtils.isBlankOrNull(this.destField.getMapSetMethod()) ? this.destField.getMapSetMethod() : this.classMap.getDestClassMapSetMethod();
    }

    public String getSrcFieldName() {
        return this.srcField.getName();
    }

    public String getDestFieldName() {
        return this.destField.getName();
    }

    public String getDestFieldType() {
        return this.destField.getType();
    }

    public String getSrcFieldType() {
        return this.srcField.getType();
    }

    public String getDateFormat() {
        if (!MappingUtils.isBlankOrNull(this.destField.getDateFormat())) {
            return this.destField.getDateFormat();
        }
        if (!MappingUtils.isBlankOrNull(this.srcField.getDateFormat())) {
            return this.srcField.getDateFormat();
        }
        return this.classMap.getDateFormat();
    }

    public String getDestFieldCreateMethod() {
        return this.destField.getCreateMethod();
    }

    public String getSrcFieldCreateMethod() {
        return this.srcField.getCreateMethod();
    }

    public boolean isDestFieldIndexed() {
        return this.destField.isIndexed();
    }

    public boolean isSrcFieldIndexed() {
        return this.srcField.isIndexed();
    }

    public int getSrcFieldIndex() {
        return this.srcField.getIndex();
    }

    public int getDestFieldIndex() {
        return this.destField.getIndex();
    }

    public String getSrcFieldTheGetMethod() {
        return this.srcField.getTheGetMethod();
    }

    public String getDestFieldTheGetMethod() {
        return this.destField.getTheGetMethod();
    }

    public String getSrcFieldTheSetMethod() {
        return this.srcField.getTheSetMethod();
    }

    public String getDestFieldTheSetMethod() {
        return this.destField.getTheSetMethod();
    }

    public String getSrcFieldKey() {
        return this.srcField.getKey();
    }

    public String getDestFieldKey() {
        return this.destField.getKey();
    }

    public boolean isDestFieldAccessible() {
        return this.determineAccess(this.destField, this.classMap.getDestClass());
    }

    public boolean isSrcFieldAccessible() {
        return this.determineAccess(this.srcField, this.classMap.getSrcClass());
    }

    private boolean determineAccess(DozerField field, DozerClass clazz) {
        Boolean fieldLevel = field.isAccessible();
        if (fieldLevel != null) {
            return fieldLevel;
        }
        return clazz.isAccessible();
    }

    public void setSrcField(DozerField sourceField) {
        this.srcField = sourceField;
    }

    public void setDestField(DozerField destField) {
        this.destField = destField;
    }

    public HintContainer getDestDeepIndexHintContainer() {
        return this.destDeepIndexHintContainer;
    }

    public void setDestDeepIndexHintContainer(HintContainer destDeepIndexHintHint) {
        this.destDeepIndexHintContainer = destDeepIndexHintHint;
    }

    public HintContainer getSrcDeepIndexHintContainer() {
        return this.srcDeepIndexHintContainer;
    }

    public void setSrcDeepIndexHintContainer(HintContainer srcDeepIndexHint) {
        this.srcDeepIndexHintContainer = srcDeepIndexHint;
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public MappingDirection getType() {
        return this.type;
    }

    public void setType(MappingDirection type) {
        this.type = type;
    }

    public boolean isCopyByReference() {
        return this.copyByReference;
    }

    public void setCopyByReference(boolean copyByReference) {
        this.copyByReference = copyByReference;
        this.copyByReferenceOveridden = true;
    }

    protected boolean isSrcSelfReferencing() {
        return this.getSrcFieldName().equals("this");
    }

    protected boolean isDestSelfReferencing() {
        return this.getDestFieldName().equals("this");
    }

    public boolean isCopyByReferenceOveridden() {
        return this.copyByReferenceOveridden;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public String getCustomConverter() {
        return this.customConverter;
    }

    public void setCustomConverter(String customConverter) {
        this.customConverter = customConverter;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType != null ? this.relationshipType : this.classMap.getRelationshipType();
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public void validate() {
        if (this.srcField == null) {
            MappingUtils.throwMappingException("src field must be specified");
        }
        if (this.destField == null) {
            MappingUtils.throwMappingException("dest field must be specified");
        }
    }

    protected DozerPropertyDescriptor getSrcPropertyDescriptor(Class<?> runtimeSrcClass) {
        DozerPropertyDescriptor result = (DozerPropertyDescriptor)this.srcPropertyDescriptorMap.get(runtimeSrcClass);
        if (result == null) {
            String srcFieldMapGetMethod = this.getSrcFieldMapGetMethod();
            String srcFieldMapSetMethod = this.getSrcFieldMapSetMethod();
            DozerPropertyDescriptor descriptor = this.propertyDescriptorFactory.getPropertyDescriptor(runtimeSrcClass, this.getSrcFieldTheGetMethod(), this.getSrcFieldTheSetMethod(), srcFieldMapGetMethod, srcFieldMapSetMethod, this.isSrcFieldAccessible(), this.isSrcFieldIndexed(), this.getSrcFieldIndex(), this.getSrcFieldName(), this.getSrcFieldKey(), this.isSrcSelfReferencing(), this.getDestFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.classMap.getSrcClassBeanFactory(), this.beanContainer, this.destBeanCreator);
            this.srcPropertyDescriptorMap.putIfAbsent(runtimeSrcClass, descriptor);
            result = descriptor;
        }
        return result;
    }

    protected DozerPropertyDescriptor getDestPropertyDescriptor(Class<?> runtimeDestClass) {
        if (BeanBuilder.class.isAssignableFrom(runtimeDestClass)) {
            MappingUtils.throwMappingException("getDestPropertyDescriptor received builder instead of concrete class - it's a bug, please post stack trace at https://github.com/DozerMapper/dozer or directly to dmitry@spikhalskiy.com ");
            return null;
        }
        DozerPropertyDescriptor result = (DozerPropertyDescriptor)this.destPropertyDescriptorMap.get(runtimeDestClass);
        if (result == null) {
            DozerPropertyDescriptor descriptor = this.propertyDescriptorFactory.getPropertyDescriptor(runtimeDestClass, this.getDestFieldTheGetMethod(), this.getDestFieldTheSetMethod(), this.getDestFieldMapGetMethod(), this.getDestFieldMapSetMethod(), this.isDestFieldAccessible(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getDestFieldName(), this.getDestFieldKey(), this.isDestSelfReferencing(), this.getSrcFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.classMap.getDestClassBeanFactory(), this.beanContainer, this.destBeanCreator);
            this.destPropertyDescriptorMap.putIfAbsent(runtimeDestClass, descriptor);
            result = descriptor;
        }
        return result;
    }

    public DozerField getSrcFieldCopy() {
        try {
            return (DozerField)this.srcField.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MappingException(e);
        }
    }

    public DozerField getDestFieldCopy() {
        try {
            return (DozerField)this.destField.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MappingException(e);
        }
    }

    protected DozerField getSrcField() {
        return this.srcField;
    }

    protected DozerField getDestField() {
        return this.destField;
    }

    public String getCustomConverterId() {
        return this.customConverterId;
    }

    public void setCustomConverterId(String customConverterId) {
        this.customConverterId = customConverterId;
    }

    public boolean isRemoveOrphans() {
        return this.removeOrphans;
    }

    public void setRemoveOrphans(boolean removeOrphans) {
        this.removeOrphans = removeOrphans;
    }

    public boolean isDestMapNull() {
        return this.classMap.isDestMapNull();
    }

    public boolean isDestMapEmptyString() {
        return this.classMap.isDestMapEmptyString();
    }

    public boolean isTrimStrings() {
        return this.classMap.isTrimStrings();
    }

    public boolean isStopOnErrors() {
        return this.classMap.isStopOnErrors();
    }

    public boolean isNonCumulativeRelationship() {
        return RelationshipType.NON_CUMULATIVE.equals(this.relationshipType);
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("source field", this.srcField).append("destination field", this.destField).append("type", this.type).append("customConverter", this.customConverter).append("relationshipType", this.relationshipType).append("removeOrphans", this.removeOrphans).append("mapId", this.mapId).append("copyByReference", this.copyByReference).append("copyByReferenceOveridden", this.copyByReferenceOveridden).append("srcTypeHint", this.srcHintContainer).append("destTypeHint", this.destHintContainer).toString();
    }

    public String getCustomConverterParam() {
        return this.customConverterParam;
    }

    public void setCustomConverterParam(String customConverterParam) {
        this.customConverterParam = customConverterParam;
    }
}

