/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.jmx;

import java.util.Set;
import java.util.TreeSet;
import org.dozer.config.GlobalSettings;
import org.dozer.jmx.DozerStatisticsControllerMBean;
import org.dozer.stats.StatisticEntry;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsManager;

@Deprecated
public class DozerStatisticsController
implements DozerStatisticsControllerMBean {
    private final StatisticsManager statsMgr;
    private final GlobalSettings globalSettings;

    public DozerStatisticsController(StatisticsManager statsMgr, GlobalSettings globalSettings) {
        this.statsMgr = statsMgr;
        this.globalSettings = globalSettings;
    }

    @Override
    public void clearAll() {
        this.statsMgr.clearAll();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.globalSettings.isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.globalSettings.setStatisticsEnabled(statisticsEnabled);
    }

    @Override
    public long getMappingSuccessCount() {
        return this.getStatisticValue(StatisticType.MAPPING_SUCCESS_COUNT);
    }

    @Override
    public long getMappingFailureCount() {
        return this.getStatisticValue(StatisticType.MAPPING_FAILURE_COUNT);
    }

    @Override
    public long getMapperInstancesCount() {
        return this.getStatisticValue(StatisticType.MAPPER_INSTANCES_COUNT);
    }

    @Override
    public long getMappingOverallTimeInMillis() {
        return this.getStatisticValue(StatisticType.MAPPING_TIME);
    }

    @Override
    public Set<String> getMappingFailureExceptionTypes() {
        return this.getStatisticEntries(StatisticType.MAPPING_FAILURE_EX_TYPE_COUNT);
    }

    @Override
    public Set<String> getMappingFailureTypes() {
        return this.getStatisticEntries(StatisticType.MAPPING_FAILURE_TYPE_COUNT);
    }

    @Override
    public Set<String> getCacheHitCount() {
        return this.getStatisticEntries(StatisticType.CACHE_HIT_COUNT);
    }

    @Override
    public Set<String> getCacheMissCount() {
        return this.getStatisticEntries(StatisticType.CACHE_MISS_COUNT);
    }

    @Override
    public long getFieldMappingSuccessCount() {
        return this.getStatisticValue(StatisticType.FIELD_MAPPING_SUCCESS_COUNT);
    }

    @Override
    public long getFieldMappingFailureCount() {
        return this.getStatisticValue(StatisticType.FIELD_MAPPING_FAILURE_COUNT);
    }

    @Override
    public long getFieldMappingFailureIgnoredCount() {
        return this.getStatisticValue(StatisticType.FIELD_MAPPING_FAILURE_IGNORED_COUNT);
    }

    @Override
    public long getCustomConverterSuccessCount() {
        return this.getStatisticValue(StatisticType.CUSTOM_CONVERTER_SUCCESS_COUNT);
    }

    @Override
    public long getCustomConverterOverallTimeInMillis() {
        return this.getStatisticValue(StatisticType.CUSTOM_CONVERTER_TIME);
    }

    @Override
    public double getMappingAverageTimeInMillis() {
        double totalTime = this.getStatisticValue(StatisticType.MAPPING_TIME);
        double totalCount = this.getStatisticValue(StatisticType.MAPPING_SUCCESS_COUNT);
        return totalTime / totalCount;
    }

    @Override
    public double getCustomConverterAverageTimeInMillis() {
        double totalTime = this.getStatisticValue(StatisticType.CUSTOM_CONVERTER_TIME);
        double totalCount = this.getStatisticValue(StatisticType.CUSTOM_CONVERTER_SUCCESS_COUNT);
        return totalTime / totalCount;
    }

    @Override
    public double getCustomConverterPercentageOfMappingTime() {
        double ccTotalTime = this.getStatisticValue(StatisticType.CUSTOM_CONVERTER_TIME);
        double overallTime = this.getStatisticValue(StatisticType.MAPPING_TIME);
        return ccTotalTime / overallTime * 100.0;
    }

    protected Set<String> getStatisticEntries(StatisticType statisticType) {
        TreeSet<String> result = new TreeSet<String>();
        for (StatisticEntry entry : this.statsMgr.getStatisticEntries(statisticType)) {
            result.add(entry.getKey().toString() + ": Count " + entry.getValue());
        }
        return result;
    }

    @Override
    public void logStatistics() {
        this.statsMgr.logStatistics();
    }

    @Override
    public String dumpStatistics() {
        return this.statsMgr.getStatistics().toString();
    }

    protected long getStatisticValue(StatisticType statisticType) {
        return this.statsMgr.getStatisticValue(statisticType);
    }
}

