/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader;

import java.util.HashSet;
import java.util.List;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingDirection;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.ExcludeFieldMap;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

public final class MappingsParser {
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public MappingsParser(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    public ClassMappings processMappings(List<ClassMap> classMaps, Configuration globalConfiguration) {
        if (globalConfiguration == null) {
            throw new IllegalArgumentException("Global configuration parameter cannot be null");
        }
        ClassMappings result = new ClassMappings(this.beanContainer);
        if (classMaps == null || classMaps.size() == 0) {
            return result;
        }
        HashSet<String> mapIds = new HashSet<String>();
        for (ClassMap classMap : classMaps) {
            classMap.setGlobalConfiguration(globalConfiguration);
            ReflectionUtils.findPropertyDescriptor(classMap.getSrcClassToMap(), "", null);
            ReflectionUtils.findPropertyDescriptor(classMap.getDestClassToMap(), "", null);
            if (!MappingUtils.isBlankOrNull(classMap.getMapId())) {
                if (mapIds.contains(classMap.getMapId())) {
                    throw new IllegalArgumentException("Duplicate Map Id's Found. Map Id: " + classMap.getMapId());
                }
                mapIds.add(classMap.getMapId());
            }
            result.add(classMap.getSrcClassToMap(), classMap.getDestClassToMap(), classMap.getMapId(), classMap);
            ClassMap classMapPrime = new ClassMap(globalConfiguration);
            MappingUtils.reverseFields(classMap, classMapPrime, this.beanContainer);
            if (classMap.getFieldMaps() != null) {
                FieldMap fieldMapPrime;
                List<FieldMap> fms = classMap.getFieldMaps();
                if (!MappingDirection.ONE_WAY.equals(classMap.getType())) {
                    for (FieldMap fieldMap : fms.toArray(new FieldMap[0])) {
                        fieldMap.validate();
                        if (!(fieldMap instanceof ExcludeFieldMap) && (MappingUtils.isSupportedMap(classMap.getDestClassToMap()) ^ MappingUtils.isSupportedMap(classMap.getSrcClassToMap()) || MappingUtils.isSupportedMap(fieldMap.getDestFieldType(classMap.getDestClassToMap())) ^ MappingUtils.isSupportedMap(fieldMap.getSrcFieldType(classMap.getSrcClassToMap())))) {
                            MapFieldMap fm = new MapFieldMap(fieldMap, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                            classMap.removeFieldMapping(fieldMap);
                            classMap.addFieldMapping(fm);
                            fieldMap = fm;
                        }
                        if (MappingUtils.isSupportedMap(classMap.getSrcClassToMap()) && fieldMap.getSrcFieldKey() == null) {
                            DozerField newSrcField = fieldMap.getSrcFieldCopy();
                            newSrcField.setName("this");
                            newSrcField.setKey(fieldMap.getSrcFieldName());
                            fieldMap.setSrcField(newSrcField);
                        }
                        if (MappingUtils.isSupportedMap(classMap.getDestClassToMap()) && fieldMap.getDestFieldKey() == null) {
                            DozerField newDestField = fieldMap.getDestFieldCopy();
                            newDestField.setName("this");
                            newDestField.setKey(fieldMap.getDestFieldName());
                            fieldMap.setDestField(newDestField);
                        }
                        if (!MappingDirection.ONE_WAY.equals(fieldMap.getType()) || fieldMap instanceof ExcludeFieldMap) {
                            fieldMapPrime = (FieldMap)fieldMap.clone();
                            fieldMapPrime.setClassMap(classMapPrime);
                            if (fieldMapPrime instanceof ExcludeFieldMap && MappingDirection.ONE_WAY.equals(fieldMap.getType())) {
                                fieldMapPrime = new GenericFieldMap(classMapPrime, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                            }
                            MappingUtils.reverseFields(fieldMap, fieldMapPrime);
                            if (!(fieldMap instanceof ExcludeFieldMap)) {
                                MappingUtils.applyGlobalCopyByReference(globalConfiguration, fieldMap, classMap);
                            }
                            if (!(fieldMapPrime instanceof ExcludeFieldMap)) {
                                MappingUtils.applyGlobalCopyByReference(globalConfiguration, fieldMapPrime, classMapPrime);
                            }
                        } else {
                            fieldMapPrime = new ExcludeFieldMap(classMapPrime, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                            MappingUtils.reverseFields(fieldMap, fieldMapPrime);
                            MappingUtils.applyGlobalCopyByReference(globalConfiguration, fieldMap, classMap);
                        }
                        classMapPrime.addFieldMapping(fieldMapPrime);
                    }
                } else {
                    for (FieldMap oneWayFieldMap : fms.toArray(new FieldMap[0])) {
                        oneWayFieldMap.validate();
                        MappingUtils.applyGlobalCopyByReference(globalConfiguration, oneWayFieldMap, classMap);
                        if (!MappingDirection.ONE_WAY.equals(oneWayFieldMap.getType())) continue;
                        fieldMapPrime = new ExcludeFieldMap(classMapPrime, this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
                        MappingUtils.reverseFields(oneWayFieldMap, fieldMapPrime);
                        classMapPrime.addFieldMapping(fieldMapPrime);
                    }
                }
            }
            if (MappingDirection.ONE_WAY.equals(classMap.getType())) continue;
            result.add(classMap.getDestClassToMap(), classMap.getSrcClassToMap(), classMap.getMapId(), classMapPrime);
        }
        return result;
    }
}

