/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.stats;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dozer.config.GlobalSettings;
import org.dozer.stats.Statistic;
import org.dozer.stats.StatisticEntry;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class StatisticsManagerImpl
implements StatisticsManager {
    private final Logger log = LoggerFactory.getLogger(StatisticsManagerImpl.class);
    private final ConcurrentMap<StatisticType, Statistic> statisticsMap = new ConcurrentHashMap<StatisticType, Statistic>();
    private final GlobalSettings globalSettings;
    private boolean isStatisticsEnabled;

    public StatisticsManagerImpl(GlobalSettings globalSettings) {
        this.isStatisticsEnabled = globalSettings.isStatisticsEnabled();
        this.globalSettings = globalSettings;
    }

    @Override
    public void clearAll() {
        this.statisticsMap.clear();
    }

    @Override
    public Set<StatisticEntry> getStatisticEntries(StatisticType statisticType) {
        Statistic statistic = (Statistic)this.statisticsMap.get((Object)statisticType);
        return statistic != null ? statistic.getEntries() : Collections.EMPTY_SET;
    }

    @Override
    public Set<Statistic> getStatistics() {
        return new HashSet<Statistic>(this.statisticsMap.values());
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.isStatisticsEnabled = statisticsEnabled;
        this.globalSettings.setStatisticsEnabled(statisticsEnabled);
    }

    @Override
    public Set<StatisticType> getStatisticTypes() {
        HashSet<StatisticType> results = new HashSet<StatisticType>();
        for (Map.Entry entry : this.statisticsMap.entrySet()) {
            results.add((StatisticType)((Object)entry.getKey()));
        }
        return results;
    }

    @Override
    public Statistic increment(StatisticType statisticType) {
        return this.increment(statisticType, 1L);
    }

    @Override
    public Statistic increment(StatisticType statisticType, long value) {
        return this.increment(statisticType, (Object)statisticType, value);
    }

    @Override
    public Statistic increment(StatisticType statisticType, Object statisticEntryKey) {
        return this.increment(statisticType, statisticEntryKey, 1L);
    }

    protected Statistic increment(StatisticType statisticType, Object statisticEntryKey, long value) {
        Statistic newStatistic;
        if (!this.isStatisticsEnabled()) {
            return null;
        }
        if (statisticType == null) {
            throw new IllegalArgumentException("statistic type must be specified");
        }
        Statistic statistic = (Statistic)this.statisticsMap.get((Object)statisticType);
        if (statistic == null && (statistic = this.statisticsMap.putIfAbsent(statisticType, newStatistic = new Statistic(statisticType))) == null) {
            statistic = newStatistic;
        }
        statistic.increment(statisticEntryKey, value);
        return statistic;
    }

    protected Statistic getStatistic(StatisticType statisticType) {
        return (Statistic)this.statisticsMap.get((Object)statisticType);
    }

    @Override
    public long getStatisticValue(StatisticType statisticType) {
        return this.getStatisticValue(statisticType, (Object)statisticType);
    }

    @Override
    public long getStatisticValue(StatisticType statisticType, Object entryKey) {
        Statistic statistic = (Statistic)this.statisticsMap.get((Object)statisticType);
        return statistic != null ? statistic.getStatisticValue(entryKey) : 0L;
    }

    @Override
    public void logStatistics() {
        this.log.info(this.getStatistics().toString());
    }
}

