/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.model.elengine;

import com.github.dozermapper.core.builder.model.elengine.ELConfigurationDefinition;
import com.github.dozermapper.core.builder.model.elengine.ELMappingDefinition;
import com.github.dozermapper.core.builder.model.jaxb.ConfigurationDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingsDefinition;
import com.github.dozermapper.core.el.ELEngine;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class ELMappingsDefinition
extends MappingsDefinition {
    private final ELEngine elEngine;

    public ELMappingsDefinition(ELEngine elEngine) {
        this(elEngine, null);
    }

    public ELMappingsDefinition(ELEngine elEngine, MappingsDefinition copy) {
        this.elEngine = elEngine;
        if (copy != null) {
            if (copy.getConfiguration() != null) {
                this.configuration = new ELConfigurationDefinition(elEngine, copy.getConfiguration());
            }
            if (copy.getMapping() != null && copy.getMapping().size() > 0) {
                this.mapping = copy.getMapping().stream().map(m -> new ELMappingDefinition(elEngine, (MappingDefinition)m)).collect(Collectors.toList());
            }
        }
    }

    @Override
    public ConfigurationDefinition withConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(new ELConfigurationDefinition(this.elEngine, this));
        }
        return this.configuration;
    }

    @Override
    public MappingDefinition addMapping() {
        if (this.mapping == null) {
            this.setMapping(new ArrayList<MappingDefinition>());
        }
        ELMappingDefinition mapping = new ELMappingDefinition(this.elEngine, this);
        this.getMapping().add(mapping);
        return mapping;
    }
}

