/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.cache;

import com.github.dozermapper.core.cache.Cache;
import com.github.dozermapper.core.cache.CacheEntry;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DefaultCache<KeyType, ValueType>
implements Cache<KeyType, ValueType> {
    private final String name;
    private final LRUMap cacheMap;

    public DefaultCache(String name, int maximumSize) {
        if (maximumSize < 1) {
            throw new IllegalArgumentException("Dozer cache max size must be greater than 0");
        }
        this.name = name;
        this.cacheMap = new LRUMap(maximumSize);
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
    }

    @Override
    public synchronized void put(KeyType key, ValueType value) {
        if (key == null) {
            throw new IllegalArgumentException("Cache entry key cannot be null");
        }
        CacheEntry<KeyType, ValueType> cacheEntry = new CacheEntry<KeyType, ValueType>(key, value);
        this.cacheMap.put(cacheEntry.getKey(), cacheEntry);
    }

    @Override
    public ValueType get(KeyType key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        CacheEntry result = (CacheEntry)this.cacheMap.get(key);
        if (result == null) {
            return null;
        }
        return result.getValue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.cacheMap.size();
    }

    @Override
    public int getMaxSize() {
        return this.cacheMap.getMaximumSize();
    }

    @Override
    public boolean containsKey(KeyType key) {
        return this.cacheMap.containsKey(key);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    private class LRUMap
    extends LinkedHashMap<KeyType, CacheEntry<KeyType, ValueType>> {
        private final int maximumSize;

        LRUMap(int maximumSize) {
            this.maximumSize = maximumSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<KeyType, CacheEntry<KeyType, ValueType>> eldest) {
            return this.size() > this.maximumSize;
        }

        private int getMaximumSize() {
            return this.maximumSize;
        }
    }
}

