/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CopyByReference {
    private static final String WILDCARD = "*";
    private String mask;
    private Pattern pattern;

    public CopyByReference(String mask) {
        this.mask = mask;
        this.pattern = this.compilePattern(mask);
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
        this.pattern = this.compilePattern(mask);
    }

    private Pattern compilePattern(String mask) {
        String regexp = StringUtils.replace(mask, ".", "\\.");
        regexp = StringUtils.replace(regexp, WILDCARD, ".*?");
        return Pattern.compile(regexp);
    }

    public boolean matches(String destFieldTypeName) {
        Matcher matcher = this.pattern.matcher(destFieldTypeName);
        return matcher.matches();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

