/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.util.MappingUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.EnumUtils;

public class EnumConverter
implements Converter {
    public Object convert(Class destClass, Object srcObj) {
        if (null == srcObj) {
            MappingUtils.throwMappingException("Cannot convert null to enum of type " + destClass);
        }
        try {
            if (srcObj.getClass().equals(Byte.class) || srcObj.getClass().equals(Byte.TYPE)) {
                return EnumUtils.getEnumList(destClass).get(((Byte)srcObj).intValue());
            }
            if (srcObj.getClass().equals(Short.class) || srcObj.getClass().equals(Short.TYPE)) {
                return EnumUtils.getEnumList(destClass).get(((Short)srcObj).intValue());
            }
            if (srcObj.getClass().equals(Integer.class) || srcObj.getClass().equals(Integer.TYPE)) {
                return EnumUtils.getEnumList(destClass).get((Integer)srcObj);
            }
            if (srcObj.getClass().equals(Long.class) || srcObj.getClass().equals(Long.TYPE)) {
                return EnumUtils.getEnumList(destClass).get(((Long)srcObj).intValue());
            }
            return Enum.valueOf(destClass, srcObj.toString());
        }
        catch (Exception e) {
            MappingUtils.throwMappingException("Cannot convert [" + srcObj + "] to enum of type " + destClass, e);
            return srcObj;
        }
    }
}

