/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.converters.ByteConverter;
import com.github.dozermapper.core.converters.CalendarConverter;
import com.github.dozermapper.core.converters.ConversionException;
import com.github.dozermapper.core.converters.DateConverter;
import com.github.dozermapper.core.converters.DateFormatContainer;
import com.github.dozermapper.core.converters.EnumConverter;
import com.github.dozermapper.core.converters.InstantConverter;
import com.github.dozermapper.core.converters.IntegerConverter;
import com.github.dozermapper.core.converters.JAXBElementConverter;
import com.github.dozermapper.core.converters.LocalDateTimeConverter;
import com.github.dozermapper.core.converters.LongConverter;
import com.github.dozermapper.core.converters.OffsetDateTimeConverter;
import com.github.dozermapper.core.converters.ShortConverter;
import com.github.dozermapper.core.converters.StringConstructorConverter;
import com.github.dozermapper.core.converters.StringConverter;
import com.github.dozermapper.core.converters.XMLGregorianCalendarConverter;
import com.github.dozermapper.core.converters.ZonedDateTimeConverter;
import com.github.dozermapper.core.util.MappingUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.lang3.ClassUtils;

public class PrimitiveOrWrapperConverter {
    private static final Map<Class, Converter> CONVERTER_MAP = new HashMap<Class, Converter>();
    private final BeanContainer beanContainer;

    public PrimitiveOrWrapperConverter(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    public Object convert(Object srcFieldValue, Class destFieldClass, DateFormatContainer dateFormatContainer) {
        return this.convert(srcFieldValue, destFieldClass, dateFormatContainer, null, null);
    }

    public Object convert(Object srcFieldValue, Class destFieldClass, DateFormatContainer dateFormatContainer, String destFieldName, Object destObj) {
        if (srcFieldValue == null || destFieldClass == null || srcFieldValue.equals("") && !destFieldClass.equals(String.class)) {
            return null;
        }
        Converter converter = this.getPrimitiveOrWrapperConverter(destFieldClass, dateFormatContainer, destFieldName, destObj);
        try {
            return converter.convert(destFieldClass, this.unwrapSrcFieldValue(srcFieldValue));
        }
        catch (org.apache.commons.beanutils.ConversionException e) {
            throw new ConversionException(e);
        }
    }

    private Object unwrapSrcFieldValue(Object srcFieldValue) {
        if (JAXBElement.class.isAssignableFrom(srcFieldValue.getClass())) {
            return ((JAXBElement)JAXBElement.class.cast(srcFieldValue)).getValue();
        }
        return srcFieldValue;
    }

    private Converter getPrimitiveOrWrapperConverter(Class destClass, DateFormatContainer dateFormatContainer, String destFieldName, Object destObj) {
        if (String.class.equals((Object)destClass)) {
            return new StringConverter(dateFormatContainer);
        }
        Converter result = CONVERTER_MAP.get(ClassUtils.primitiveToWrapper(destClass));
        if (result == null) {
            if (Date.class.isAssignableFrom(destClass)) {
                result = new DateConverter(dateFormatContainer.getDateFormat());
            } else if (Calendar.class.isAssignableFrom(destClass)) {
                result = new CalendarConverter(dateFormatContainer.getDateFormat());
            } else if (XMLGregorianCalendar.class.isAssignableFrom(destClass)) {
                result = new XMLGregorianCalendarConverter(dateFormatContainer.getDateFormat());
            } else if (MappingUtils.isEnumType(destClass)) {
                result = new EnumConverter();
            } else if (JAXBElement.class.isAssignableFrom(destClass) && destFieldName != null) {
                result = new JAXBElementConverter(destObj.getClass().getCanonicalName(), destFieldName, dateFormatContainer.getDateFormat(), this.beanContainer);
            } else if (PrimitiveOrWrapperConverter.isLocalTime(destClass)) {
                result = new LocalDateTimeConverter(dateFormatContainer.getDateTimeFormatter());
            } else if (PrimitiveOrWrapperConverter.isOffsetTime(destClass)) {
                result = new OffsetDateTimeConverter(dateFormatContainer.getDateTimeFormatter());
            } else if (ZonedDateTime.class.isAssignableFrom(destClass)) {
                result = new ZonedDateTimeConverter(dateFormatContainer.getDateTimeFormatter());
            } else if (Instant.class.isAssignableFrom(destClass)) {
                result = new InstantConverter();
            }
        }
        return result == null ? new StringConstructorConverter(dateFormatContainer) : result;
    }

    public boolean accepts(Class<?> aClass) {
        return aClass.isPrimitive() || Number.class.isAssignableFrom(aClass) || String.class.equals(aClass) || Character.class.equals(aClass) || Boolean.class.equals(aClass) || Date.class.isAssignableFrom(aClass) || Calendar.class.isAssignableFrom(aClass) || aClass.isEnum() || LocalDateTime.class.isAssignableFrom(aClass) || LocalDate.class.isAssignableFrom(aClass) || LocalTime.class.isAssignableFrom(aClass) || OffsetDateTime.class.isAssignableFrom(aClass) || OffsetTime.class.isAssignableFrom(aClass) || ZonedDateTime.class.isAssignableFrom(aClass) || Instant.class.isAssignableFrom(aClass);
    }

    private static boolean isLocalTime(Class clazz) {
        return LocalDateTime.class.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz) || LocalTime.class.isAssignableFrom(clazz);
    }

    private static boolean isOffsetTime(Class clazz) {
        return OffsetDateTime.class.isAssignableFrom(clazz) || OffsetTime.class.isAssignableFrom(clazz);
    }

    static {
        CONVERTER_MAP.put(Integer.class, new IntegerConverter());
        CONVERTER_MAP.put(Double.class, new DoubleConverter());
        CONVERTER_MAP.put(Short.class, new ShortConverter());
        CONVERTER_MAP.put(Character.class, new CharacterConverter());
        CONVERTER_MAP.put(Long.class, new LongConverter());
        CONVERTER_MAP.put(Boolean.class, new BooleanConverter());
        CONVERTER_MAP.put(Byte.class, new ByteConverter());
        CONVERTER_MAP.put(Float.class, new FloatConverter());
        CONVERTER_MAP.put(BigDecimal.class, new BigDecimalConverter());
        CONVERTER_MAP.put(BigInteger.class, new BigIntegerConverter());
        CONVERTER_MAP.put(Class.class, new ClassConverter());
    }
}

