/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.util;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.propertydescriptor.DeepHierarchyElement;
import com.github.dozermapper.core.util.MappingUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public final class ReflectionUtils {
    private static final String IAE_MESSAGE = "argument type mismatch";

    private ReflectionUtils() {
    }

    public static PropertyDescriptor findPropertyDescriptor(Class<?> objectClass, String fieldName, HintContainer deepIndexHintContainer) {
        PropertyDescriptor result = null;
        if (MappingUtils.isDeepMapping(fieldName)) {
            DeepHierarchyElement[] hierarchy = ReflectionUtils.getDeepFieldHierarchy(objectClass, fieldName, deepIndexHintContainer);
            result = hierarchy[hierarchy.length - 1].getPropDescriptor();
        } else {
            PropertyDescriptor[] descriptors = ReflectionUtils.getPropertyDescriptors(objectClass);
            if (descriptors != null) {
                int size = descriptors.length;
                for (int i = 0; i < size; ++i) {
                    String propertyName = descriptors[i].getName();
                    Method readMethod = descriptors[i].getReadMethod();
                    if (fieldName.equals(propertyName)) {
                        return ReflectionUtils.fixGenericDescriptor(objectClass, descriptors[i]);
                    }
                    if (!fieldName.equalsIgnoreCase(propertyName)) continue;
                    result = descriptors[i];
                }
            }
        }
        return result;
    }

    private static PropertyDescriptor fixGenericDescriptor(Class<?> clazz, PropertyDescriptor descriptor) {
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null && (readMethod.isBridge() || readMethod.isSynthetic())) {
            String propertyName = descriptor.getName();
            String baseName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            String setMethodName = "set" + baseName;
            String getMethodName = "get" + baseName;
            Method getMethod = ReflectionUtils.findPreferablyNonSyntheticMethod(getMethodName, clazz);
            Method setMethod = ReflectionUtils.findPreferablyNonSyntheticMethod(setMethodName, clazz);
            try {
                return new PropertyDescriptor(propertyName, getMethod, setMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return descriptor;
    }

    private static Method findPreferablyNonSyntheticMethod(String methodName, Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Method syntheticMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            if (!method.isBridge() && !method.isSynthetic()) {
                return method;
            }
            syntheticMethod = method;
        }
        return syntheticMethod;
    }

    public static DeepHierarchyElement[] getDeepFieldHierarchy(Class<?> parentClass, String field, HintContainer deepIndexHintContainer) {
        if (!MappingUtils.isDeepMapping(field)) {
            MappingUtils.throwMappingException("Field does not contain deep field delimitor");
        }
        StringTokenizer toks = new StringTokenizer(field, ".");
        Class<?> latestClass = parentClass;
        DeepHierarchyElement[] hierarchy = new DeepHierarchyElement[toks.countTokens()];
        int index = 0;
        int hintIndex = 0;
        while (toks.hasMoreTokens()) {
            String aFieldName;
            String theFieldName = aFieldName = toks.nextToken();
            int collectionIndex = -1;
            if (aFieldName.contains("[")) {
                theFieldName = aFieldName.substring(0, aFieldName.indexOf("["));
                collectionIndex = Integer.parseInt(aFieldName.substring(aFieldName.indexOf("[") + 1, aFieldName.indexOf("]")));
            }
            PropertyDescriptor propDescriptor = ReflectionUtils.findPropertyDescriptor(latestClass, theFieldName, deepIndexHintContainer);
            DeepHierarchyElement r = new DeepHierarchyElement(propDescriptor, collectionIndex);
            if (propDescriptor == null) {
                MappingUtils.throwMappingException("Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
            }
            latestClass = propDescriptor.getPropertyType();
            if (toks.hasMoreTokens()) {
                if (latestClass.isArray()) {
                    latestClass = latestClass.getComponentType();
                } else if (Collection.class.isAssignableFrom(latestClass)) {
                    Class<?> genericType = ReflectionUtils.determineGenericsType(parentClass.getClass(), propDescriptor);
                    if (genericType == null && deepIndexHintContainer == null) {
                        MappingUtils.throwMappingException("Hint(s) or Generics not specified.  Hint(s) or Generics must be specified for deep mapping with indexed field(s). Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
                    }
                    if (genericType != null) {
                        latestClass = genericType;
                    } else {
                        latestClass = deepIndexHintContainer.getHint(hintIndex);
                        ++hintIndex;
                    }
                }
            }
            hierarchy[index++] = r;
        }
        return hierarchy;
    }

    public static Method getMethod(Object obj, String methodName) {
        return ReflectionUtils.getMethod(obj.getClass(), methodName);
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method result = ReflectionUtils.findMethod(clazz, methodName);
        if (result == null) {
            MappingUtils.throwMappingException("No method found for class:" + clazz + " and method name:" + methodName);
        }
        return result;
    }

    private static Method findMethod(Class<?> clazz, String methodName) {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            result = method;
        }
        return result;
    }

    public static Method findAMethod(Class<?> clazz, String methodName, BeanContainer beanContainer) throws NoSuchMethodException {
        Method result;
        StringTokenizer tokenizer = new StringTokenizer(methodName, "(");
        String m = tokenizer.nextToken();
        if (tokenizer.hasMoreElements()) {
            StringTokenizer tokens = new StringTokenizer(tokenizer.nextToken(), ")");
            String params = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            result = ReflectionUtils.findMethodWithParam(clazz, m, params, beanContainer);
        } else {
            result = ReflectionUtils.findMethod(clazz, methodName);
        }
        if (result == null) {
            throw new NoSuchMethodException(clazz.getName() + "." + methodName);
        }
        return result;
    }

    private static Method findMethodWithParam(Class<?> parentDestClass, String methodName, String params, BeanContainer beanContainer) throws NoSuchMethodException {
        ArrayList list = new ArrayList();
        if (params != null) {
            StringTokenizer tokenizer = new StringTokenizer(params, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                list.add(MappingUtils.loadClass(token, beanContainer));
            }
        }
        return ReflectionUtils.getMethod(parentDestClass, methodName, list.toArray(new Class[list.size()]));
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> objectClass) {
        if (objectClass.isInterface()) {
            return ReflectionUtils.getInterfacePropertyDescriptors(objectClass);
        }
        return PropertyUtils.getPropertyDescriptors(objectClass);
    }

    static PropertyDescriptor[] getInterfacePropertyDescriptors(Class<?> interfaceClass) {
        ArrayList<PropertyDescriptor> propDescriptors = new ArrayList<PropertyDescriptor>();
        propDescriptors.addAll(Arrays.asList(PropertyUtils.getPropertyDescriptors(interfaceClass)));
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> superInterfaceClass : interfaces) {
                List<PropertyDescriptor> superInterfacePropertyDescriptors = Arrays.asList(ReflectionUtils.getInterfacePropertyDescriptors(superInterfaceClass));
                for (PropertyDescriptor superPropDescriptor : superInterfacePropertyDescriptors) {
                    PropertyDescriptor existingPropDescriptor = ReflectionUtils.findPropDescriptorByName(propDescriptors, superPropDescriptor.getName());
                    if (existingPropDescriptor == null) {
                        propDescriptors.add(superPropDescriptor);
                        continue;
                    }
                    try {
                        if (existingPropDescriptor.getReadMethod() == null) {
                            existingPropDescriptor.setReadMethod(superPropDescriptor.getReadMethod());
                        }
                        if (existingPropDescriptor.getWriteMethod() != null) continue;
                        existingPropDescriptor.setWriteMethod(superPropDescriptor.getWriteMethod());
                    }
                    catch (IntrospectionException e) {
                        throw new MappingException(e);
                    }
                }
            }
        }
        return propDescriptors.toArray(new PropertyDescriptor[propDescriptors.size()]);
    }

    private static PropertyDescriptor findPropDescriptorByName(List<PropertyDescriptor> propDescriptors, String name) {
        PropertyDescriptor result = null;
        for (PropertyDescriptor pd : propDescriptors) {
            if (!pd.getName().equals(name)) continue;
            result = pd;
            break;
        }
        return result;
    }

    public static Field getFieldFromBean(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getFieldFromBean(clazz, fieldName, clazz);
    }

    private static Field getFieldFromBean(Class<?> clazz, String fieldName, Class<?> originalClass) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtils.getFieldFromBean(clazz.getSuperclass(), fieldName, originalClass);
            }
            throw new MappingException("No such field found " + originalClass.getName() + "." + fieldName, e);
        }
    }

    public static Object invoke(Method method, Object obj, Object[] args) {
        Object result = null;
        try {
            method.setAccessible(true);
            result = method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals(IAE_MESSAGE)) {
                MappingUtils.throwMappingException(ReflectionUtils.prepareExceptionMessage(method, args), e);
            }
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (InvocationTargetException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    private static String prepareExceptionMessage(Method method, Object[] args) {
        StringBuffer message = new StringBuffer("Illegal object type for the method '" + method.getName() + "'. \n ");
        message.append("Expected types: \n");
        for (Class<?> type : method.getParameterTypes()) {
            message.append(type.getName());
        }
        message.append("\n Actual types: \n");
        for (Object param : args) {
            message.append(param.getClass().getName());
        }
        return message.toString();
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return clazz.getMethod(name, parameterTypes);
    }

    public static <T> T newInstance(Class<T> clazz) {
        T result = null;
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public static Class<?> determineGenericsType(Class<?> parentClazz, PropertyDescriptor propDescriptor) {
        Class<?> result = null;
        if (propDescriptor.getWriteMethod() != null) {
            result = ReflectionUtils.determineGenericsType(parentClazz, propDescriptor.getWriteMethod(), false);
        }
        if (result == null && propDescriptor.getReadMethod() != null) {
            result = ReflectionUtils.determineGenericsType(parentClazz, propDescriptor.getReadMethod(), true);
        }
        return result;
    }

    public static Class<?> determineGenericsType(Class<?> clazz, Method method, boolean isReadMethod) {
        Type genericSuperclass;
        Class<?> result = null;
        if (isReadMethod) {
            Type parameterType = method.getGenericReturnType();
            result = ReflectionUtils.determineGenericsType(parameterType);
        } else {
            Type[] parameterTypes = method.getGenericParameterTypes();
            if (parameterTypes != null) {
                result = ReflectionUtils.determineGenericsType(parameterTypes[0]);
            }
        }
        if (result == null && (genericSuperclass = clazz.getGenericSuperclass()) != null) {
            result = ReflectionUtils.determineGenericsType(genericSuperclass);
        }
        return result;
    }

    public static Class<?> determineGenericsType(Type type) {
        Type genericType;
        Class result = null;
        if (type != null && ParameterizedType.class.isAssignableFrom(type.getClass()) && (genericType = ((ParameterizedType)type).getActualTypeArguments()[0]) != null) {
            if (genericType instanceof Class) {
                result = (Class)genericType;
            } else if (genericType instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)genericType).getRawType();
                result = (Class)rawType;
            }
        }
        return result;
    }

    public static Method getNonStandardSetter(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = ReflectionUtils.getFieldFromBean(clazz, fieldName);
        }
        catch (MappingException me) {
            return null;
        }
        String methodName = "set" + StringUtils.capitalize(fieldName);
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isNonVoidSetter(method, methodName) && !ReflectionUtils.isAutoboxingSetter(method, methodName, field)) continue;
            return method;
        }
        return null;
    }

    private static boolean isNonVoidSetter(Method method, String setterMethodName) {
        return method.getName().equals(setterMethodName) && method.getParameterTypes().length == 1 && method.getReturnType() != Void.TYPE;
    }

    private static boolean isAutoboxingSetter(Method method, String setterMethodName, Field field) {
        return method.getName().equals(setterMethodName) && method.getParameterTypes().length == 1 && ReflectionUtils.canBeAutoboxed(method.getParameterTypes()[0], field.getType());
    }

    private static boolean canBeAutoboxed(Class<?> classA, Class<?> classB) {
        return ClassUtils.isPrimitiveOrWrapper(classA) && ClassUtils.isPrimitiveOrWrapper(classB) && (classB.equals(classA) || ClassUtils.primitiveToWrapper(classB).equals(classA) || ClassUtils.primitiveToWrapper(classA).equals(classB));
    }
}

