/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap;

import org.apache.commons.lang3.StringUtils;

public final class RelationshipType {
    public static final RelationshipType CUMULATIVE = new RelationshipType();
    public static final RelationshipType NON_CUMULATIVE = new RelationshipType();
    private static final String CUMULATIVE_VALUE = "cumulative";
    private static final String NON_CUMULATIVE_VALUE = "non-cumulative";

    private RelationshipType() {
    }

    public static RelationshipType valueOf(String relationshipType) {
        if (CUMULATIVE_VALUE.equals(relationshipType)) {
            return CUMULATIVE;
        }
        if (NON_CUMULATIVE_VALUE.equals(relationshipType)) {
            return NON_CUMULATIVE;
        }
        if (StringUtils.isEmpty(relationshipType)) {
            return null;
        }
        throw new IllegalStateException("relationship-type should be cumulative or non-cumulative. " + relationshipType);
    }
}

