/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.filerequests.FileRequestDeadline;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

public class FileRequest {
    protected final String id;
    protected final String url;
    protected final String title;
    protected final String destination;
    protected final Date created;
    protected final FileRequestDeadline deadline;
    protected final boolean isOpen;
    protected final long fileCount;

    public FileRequest(String id, String url, String title, Date created, boolean isOpen, long fileCount, String destination, FileRequestDeadline deadline) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z]+", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        if (url.length() < 1) {
            throw new IllegalArgumentException("String 'url' is shorter than 1");
        }
        this.url = url;
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        if (title.length() < 1) {
            throw new IllegalArgumentException("String 'title' is shorter than 1");
        }
        this.title = title;
        if (destination != null && !Pattern.matches("/(.|[\\r\\n])*", destination)) {
            throw new IllegalArgumentException("String 'destination' does not match pattern");
        }
        this.destination = destination;
        if (created == null) {
            throw new IllegalArgumentException("Required value for 'created' is null");
        }
        this.created = LangUtil.truncateMillis(created);
        this.deadline = deadline;
        this.isOpen = isOpen;
        this.fileCount = fileCount;
    }

    public FileRequest(String id, String url, String title, Date created, boolean isOpen, long fileCount) {
        this(id, url, title, created, isOpen, fileCount, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public String getDestination() {
        return this.destination;
    }

    public FileRequestDeadline getDeadline() {
        return this.deadline;
    }

    public static Builder newBuilder(String id, String url, String title, Date created, boolean isOpen, long fileCount) {
        return new Builder(id, url, title, created, isOpen, fileCount);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.url, this.title, this.destination, this.created, this.deadline, this.isOpen, this.fileCount});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequest other = (FileRequest)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.url != other.url && !this.url.equals(other.url) || this.title != other.title && !this.title.equals(other.title) || this.created != other.created && !this.created.equals(other.created) || this.isOpen != other.isOpen || this.fileCount != other.fileCount || this.destination != other.destination && (this.destination == null || !this.destination.equals(other.destination)) || this.deadline != other.deadline && (this.deadline == null || !this.deadline.equals(other.deadline)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequest> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequest value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g);
            g.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g);
            g.writeFieldName("created");
            StoneSerializers.timestamp().serialize(value.created, g);
            g.writeFieldName("is_open");
            StoneSerializers.boolean_().serialize((Boolean)value.isOpen, g);
            g.writeFieldName("file_count");
            StoneSerializers.int64().serialize((Long)value.fileCount, g);
            if (value.destination != null) {
                g.writeFieldName("destination");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.destination, g);
            }
            if (value.deadline != null) {
                g.writeFieldName("deadline");
                StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).serialize(value.deadline, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequest deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileRequestDeadline f_deadline;
            String f_destination;
            Long f_fileCount;
            Boolean f_isOpen;
            Date f_created;
            String f_title;
            String f_url;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_url = null;
                f_title = null;
                f_created = null;
                f_isOpen = null;
                f_fileCount = null;
                f_destination = null;
                f_deadline = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("is_open".equals(field)) {
                        f_isOpen = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("file_count".equals(field)) {
                        f_fileCount = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    if ("destination".equals(field)) {
                        f_destination = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("deadline".equals(field)) {
                        f_deadline = StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
                if (f_title == null) {
                    throw new JsonParseException(p, "Required field \"title\" missing.");
                }
                if (f_created == null) {
                    throw new JsonParseException(p, "Required field \"created\" missing.");
                }
                if (f_isOpen == null) {
                    throw new JsonParseException(p, "Required field \"is_open\" missing.");
                }
                if (f_fileCount == null) {
                    throw new JsonParseException(p, "Required field \"file_count\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequest value = new FileRequest(f_id, f_url, f_title, f_created, f_isOpen, f_fileCount, f_destination, f_deadline);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String id;
        protected final String url;
        protected final String title;
        protected final Date created;
        protected final boolean isOpen;
        protected final long fileCount;
        protected String destination;
        protected FileRequestDeadline deadline;

        protected Builder(String id, String url, String title, Date created, boolean isOpen, long fileCount) {
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", id)) {
                throw new IllegalArgumentException("String 'id' does not match pattern");
            }
            this.id = id;
            if (url == null) {
                throw new IllegalArgumentException("Required value for 'url' is null");
            }
            if (url.length() < 1) {
                throw new IllegalArgumentException("String 'url' is shorter than 1");
            }
            this.url = url;
            if (title == null) {
                throw new IllegalArgumentException("Required value for 'title' is null");
            }
            if (title.length() < 1) {
                throw new IllegalArgumentException("String 'title' is shorter than 1");
            }
            this.title = title;
            if (created == null) {
                throw new IllegalArgumentException("Required value for 'created' is null");
            }
            this.created = LangUtil.truncateMillis(created);
            this.isOpen = isOpen;
            this.fileCount = fileCount;
            this.destination = null;
            this.deadline = null;
        }

        public Builder withDestination(String destination) {
            if (destination != null && !Pattern.matches("/(.|[\\r\\n])*", destination)) {
                throw new IllegalArgumentException("String 'destination' does not match pattern");
            }
            this.destination = destination;
            return this;
        }

        public Builder withDeadline(FileRequestDeadline deadline) {
            this.deadline = deadline;
            return this;
        }

        public FileRequest build() {
            return new FileRequest(this.id, this.url, this.title, this.created, this.isOpen, this.fileCount, this.destination, this.deadline);
        }
    }
}

