/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum PaperDownloadFormat {
    DOCX,
    HTML,
    MARKDOWN,
    PDF,
    OTHER;


    static class Serializer
    extends UnionSerializer<PaperDownloadFormat> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDownloadFormat value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case DOCX: {
                    g.writeString("docx");
                    break;
                }
                case HTML: {
                    g.writeString("html");
                    break;
                }
                case MARKDOWN: {
                    g.writeString("markdown");
                    break;
                }
                case PDF: {
                    g.writeString("pdf");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public PaperDownloadFormat deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            PaperDownloadFormat value = "docx".equals(tag) ? DOCX : ("html".equals(tag) ? HTML : ("markdown".equals(tag) ? MARKDOWN : ("pdf".equals(tag) ? PDF : OTHER)));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

