/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxDelResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxHelper;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;
import org.apache.camel.component.dropbox.validator.DropboxConfigurationValidator;

public class DropboxDelProducer
extends DropboxProducer {
    public DropboxDelProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String remotePath = DropboxHelper.getRemotePath(this.configuration, exchange);
        DropboxConfigurationValidator.validateDelOp(remotePath);
        DropboxDelResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).del(remotePath);
        exchange.getIn().setHeader(DropboxResultHeader.DELETED_PATH.name(), result.getEntry());
        exchange.getIn().setBody(result.getEntry());
    }
}

