/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxFileUploadResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxHelper;
import org.apache.camel.component.dropbox.util.DropboxResultCode;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.component.dropbox.validator.DropboxConfigurationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxPutProducer
extends DropboxProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxPutProducer.class);

    public DropboxPutProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String remotePath = DropboxHelper.getRemotePath(this.configuration, exchange);
        String localPath = DropboxHelper.getLocalPath(this.configuration, exchange);
        DropboxUploadMode uploadMode = DropboxHelper.getUploadMode(this.configuration, exchange);
        DropboxConfigurationValidator.validatePutOp(localPath, remotePath, uploadMode);
        DropboxFileUploadResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).put(localPath, remotePath, uploadMode);
        Map<String, DropboxResultCode> map = result.getResults();
        if (map.size() == 1) {
            for (Map.Entry<String, DropboxResultCode> entry : map.entrySet()) {
                exchange.getIn().setHeader(DropboxResultHeader.UPLOADED_FILE.name(), entry.getKey());
                exchange.getIn().setBody((Object)entry.getValue());
            }
        } else {
            StringBuilder pathsExtracted = new StringBuilder();
            for (Map.Entry<String, DropboxResultCode> entry : map.entrySet()) {
                pathsExtracted.append(entry.getKey()).append("\n");
            }
            exchange.getIn().setHeader(DropboxResultHeader.UPLOADED_FILES.name(), pathsExtracted.toString());
            exchange.getIn().setBody(map);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Uploaded: {}", (Object)result);
        }
    }
}

