/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.validator;

import java.io.File;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.util.ObjectHelper;

public final class DropboxConfigurationValidator {
    private DropboxConfigurationValidator() {
    }

    public static void validateCommonProperties(DropboxConfiguration configuration) throws DropboxException {
        if (configuration.getAccessToken() == null || configuration.getAccessToken().equals("")) {
            throw new DropboxException("option <accessToken> is not present or not valid!");
        }
        if (configuration.getClientIdentifier() == null || configuration.getClientIdentifier().equals("")) {
            throw new DropboxException("option <clientIdentifier> is not present or not valid!");
        }
    }

    public static void validateGetOp(String remotePath) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(remotePath);
    }

    public static void validatePutOp(String localPath, String remotePath, DropboxUploadMode uploadMode) throws DropboxException {
        DropboxConfigurationValidator.validateLocalPath(localPath);
        if (remotePath != null) {
            DropboxConfigurationValidator.validateRemotePathForPut(remotePath);
        } else {
            DropboxConfigurationValidator.validatePathInUnix(localPath);
        }
        if (uploadMode == null) {
            throw new DropboxException("option <uploadMode> is not present or not valid!");
        }
    }

    public static void validateSearchOp(String remotePath) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(remotePath);
    }

    public static void validateDelOp(String remotePath) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(remotePath);
    }

    public static void validateMoveOp(String remotePath, String newRemotePath) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(remotePath);
        DropboxConfigurationValidator.validateRemotePath(newRemotePath);
    }

    private static void validateLocalPath(String localPath) throws DropboxException {
        File file;
        if (ObjectHelper.isNotEmpty(localPath) && !(file = new File(localPath)).exists()) {
            throw new DropboxException("option <localPath> is not an existing file or directory!");
        }
    }

    private static void validateRemotePath(String remotePath) throws DropboxException {
        if (remotePath == null || !remotePath.startsWith("/")) {
            throw new DropboxException("option <remotePath> is not valid!");
        }
        DropboxConfigurationValidator.validatePathInUnix(remotePath);
    }

    private static void validateRemotePathForPut(String remotePath) throws DropboxException {
        if (!remotePath.startsWith("/")) {
            throw new DropboxException("option <remotePath> is not valid!");
        }
        DropboxConfigurationValidator.validatePathInUnix(remotePath);
    }

    private static void validatePathInUnix(String path) throws DropboxException {
        if (path.indexOf(92) != -1) {
            throw new DropboxException(path + " must not contain Windows path separator, use UNIX path separator!");
        }
    }
}

