/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheConstants;
import org.apache.camel.component.ehcache.EhcacheConsumer;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.component.ehcache.EhcacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.18.0", scheme="ehcache", title="Ehcache", syntax="ehcache:cacheName", category={Category.CACHE, Category.DATAGRID, Category.CLUSTERING}, headersClass=EhcacheConstants.class)
public class EhcacheEndpoint
extends DefaultEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheComponent.class);
    @UriPath(description="the cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final EhcacheConfiguration configuration;
    private EhcacheManager cacheManager;

    EhcacheEndpoint(String uri, EhcacheComponent component, String cacheName, EhcacheConfiguration configuration) {
        super(uri, component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new EhcacheProducer(this, this.cacheName, this.configuration);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        EhcacheConsumer consumer = new EhcacheConsumer(this, this.cacheName, this.configuration, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public EhcacheComponent getComponent() {
        return (EhcacheComponent)super.getComponent();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.cacheManager == null) {
            this.cacheManager = this.getComponent().createCacheManager(this.configuration);
        }
        ServiceHelper.startService((Object)this.cacheManager);
        this.cacheManager.incRef();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.cacheManager);
        if (this.cacheManager != null) {
            this.cacheManager.decRef();
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.cacheManager);
    }

    EhcacheManager getManager() {
        return this.cacheManager;
    }

    EhcacheConfiguration getConfiguration() {
        return this.configuration;
    }
}

