/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.io.File;
import java.util.List;
import org.apache.camel.component.elasticsearch.ElasticsearchConstants;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

@UriParams
public class ElasticsearchConfiguration {
    private boolean local;
    private List<InetSocketTransportAddress> transportAddressesList;
    @UriPath
    @Metadata(required="true")
    private String clusterName;
    @UriParam(enums="INDEX,UPDATE,BULK,BULK_INDEX,GET_BY_ID,MULTIGET,DELETE,EXISTS,SEARCH,MULTISEARCH")
    private String operation;
    @UriParam
    private String indexName;
    @UriParam
    private String indexType;
    @UriParam(defaultValue="DEFAULT")
    private WriteConsistencyLevel consistencyLevel = ElasticsearchConstants.DEFAULT_CONSISTENCY_LEVEL;
    @UriParam
    private Boolean data;
    @UriParam
    private String ip;
    @UriParam
    private String transportAddresses;
    @UriParam(defaultValue="9300")
    private int port = ElasticsearchConstants.DEFAULT_PORT;
    @UriParam(defaultValue="true")
    private Boolean clientTransportSniff = true;
    @UriParam(defaultValue="${user.home}/.elasticsearch")
    private String pathHome = System.getProperty("user.home") + File.separator + ".elasticsearch";

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public WriteConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public Boolean getData() {
        return this.data;
    }

    public void setData(Boolean data) {
        this.data = data;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getTransportAddresses() {
        return this.transportAddresses;
    }

    public void setTransportAddresses(String transportAddresses) {
        this.transportAddresses = transportAddresses;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Boolean getClientTransportSniff() {
        return this.clientTransportSniff;
    }

    public void setClientTransportSniff(Boolean clientTransportSniff) {
        this.clientTransportSniff = clientTransportSniff;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public List<InetSocketTransportAddress> getTransportAddressesList() {
        return this.transportAddressesList;
    }

    public void setTransportAddressesList(List<InetSocketTransportAddress> transportAddressesList) {
        this.transportAddressesList = transportAddressesList;
    }

    public String getPathHome() {
        return this.pathHome;
    }

    public void setPathHome(String pathHome) {
        this.pathHome = pathHome;
    }
}

