/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.bkdtree.BKDTreeWriter;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

class BKDTreeDocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    final DocValuesConsumer delegate;
    final int maxPointsInLeafNode;
    final int maxPointsSortInHeap;
    final IndexOutput out;
    final Map<Integer, Long> fieldIndexFPs = new HashMap<Integer, Long>();
    final SegmentWriteState state;

    public BKDTreeDocValuesConsumer(DocValuesConsumer delegate, SegmentWriteState state, int maxPointsInLeafNode, int maxPointsSortInHeap) throws IOException {
        BKDTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.delegate = delegate;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.state = state;
        String datFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "kdd");
        this.out = state.directory.createOutput(datFileName, state.context);
        CodecUtil.writeIndexHeader(this.out, "BKDData", 0, state.segmentInfo.getId(), state.segmentSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block12: {
            IndexOutput metaOut;
            block10: {
                boolean success;
                block11: {
                    block9: {
                        success = false;
                        try {
                            CodecUtil.writeFooter(this.out);
                            success = true;
                            if (!success) break block9;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close(this.delegate, this.out);
                            } else {
                                IOUtils.closeWhileHandlingException(this.delegate, this.out);
                            }
                            throw throwable;
                        }
                        IOUtils.close(this.delegate, this.out);
                        break block11;
                    }
                    IOUtils.closeWhileHandlingException(this.delegate, this.out);
                }
                String metaFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, "kdm");
                metaOut = this.state.directory.createOutput(metaFileName, this.state.context);
                success = false;
                try {
                    CodecUtil.writeIndexHeader(metaOut, "BKDMeta", 0, this.state.segmentInfo.getId(), this.state.segmentSuffix);
                    metaOut.writeVInt(this.fieldIndexFPs.size());
                    for (Map.Entry<Integer, Long> ent : this.fieldIndexFPs.entrySet()) {
                        metaOut.writeVInt(ent.getKey());
                        metaOut.writeVLong(ent.getValue());
                    }
                    CodecUtil.writeFooter(metaOut);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(metaOut);
                    } else {
                        IOUtils.closeWhileHandlingException(metaOut);
                    }
                    throw throwable;
                }
                IOUtils.close(metaOut);
                break block12;
            }
            IOUtils.closeWhileHandlingException(metaOut);
        }
    }

    @Override
    public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        this.delegate.addSortedNumericField(field, docToValueCount, values);
        BKDTreeWriter writer = new BKDTreeWriter(this.maxPointsInLeafNode, this.maxPointsSortInHeap);
        Iterator<Number> valueIt = values.iterator();
        Iterator<Number> valueCountIt = docToValueCount.iterator();
        for (int docID = 0; docID < this.state.segmentInfo.maxDoc(); ++docID) {
            assert (valueCountIt.hasNext());
            int count = valueCountIt.next().intValue();
            for (int i = 0; i < count; ++i) {
                assert (valueIt.hasNext());
                long value = valueIt.next().longValue();
                int latEnc = (int)(value >> 32);
                int lonEnc = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                writer.add(latEnc, lonEnc, docID);
            }
        }
        long indexStartFP = writer.finish(this.out);
        this.fieldIndexFPs.put(field.number, indexStartFP);
    }

    @Override
    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) {
        throw new UnsupportedOperationException();
    }
}

