/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.bkdtree3d.GrowingHeapWriter;
import org.apache.lucene.bkdtree3d.HeapWriter;
import org.apache.lucene.bkdtree3d.OfflineWriter;
import org.apache.lucene.bkdtree3d.Reader;
import org.apache.lucene.bkdtree3d.Writer;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.OfflineSorter;

class BKD3DTreeWriter {
    static final int BYTES_PER_DOC = 24;
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 1024;
    public static final int DEFAULT_MAX_POINTS_SORT_IN_HEAP = 131072;
    private final byte[] scratchBytes = new byte[24];
    private final ByteArrayDataOutput scratchBytesOutput = new ByteArrayDataOutput(this.scratchBytes);
    private OfflineSorter.ByteSequencesWriter writer;
    private GrowingHeapWriter heapWriter;
    private Path tempInput;
    private final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    private long pointCount;
    private final int[] scratchDocIDs;

    public BKD3DTreeWriter() throws IOException {
        this(1024, 131072);
    }

    public BKD3DTreeWriter(int maxPointsInLeafNode, int maxPointsSortInHeap) throws IOException {
        BKD3DTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.scratchDocIDs = new int[maxPointsInLeafNode];
        this.heapWriter = new GrowingHeapWriter(maxPointsSortInHeap);
    }

    public static void verifyParams(int maxPointsInLeafNode, int maxPointsSortInHeap) {
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
        if (maxPointsSortInHeap < maxPointsInLeafNode) {
            throw new IllegalArgumentException("maxPointsSortInHeap must be >= maxPointsInLeafNode; got " + maxPointsSortInHeap + " vs maxPointsInLeafNode=" + maxPointsInLeafNode);
        }
        if (maxPointsSortInHeap > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsSortInHeap must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsSortInHeap);
        }
    }

    private void switchToOffline() throws IOException {
        this.tempInput = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "in", "", new FileAttribute[0]);
        this.writer = new OfflineSorter.ByteSequencesWriter(this.tempInput);
        int i = 0;
        while ((long)i < this.pointCount) {
            this.scratchBytesOutput.reset(this.scratchBytes);
            this.scratchBytesOutput.writeInt(this.heapWriter.xs[i]);
            this.scratchBytesOutput.writeInt(this.heapWriter.ys[i]);
            this.scratchBytesOutput.writeInt(this.heapWriter.zs[i]);
            this.scratchBytesOutput.writeVInt(this.heapWriter.docIDs[i]);
            this.scratchBytesOutput.writeVLong(i);
            this.writer.write(this.scratchBytes, 0, this.scratchBytes.length);
            ++i;
        }
        this.heapWriter = null;
    }

    public void add(int x, int y, int z, int docID) throws IOException {
        if (this.pointCount >= (long)this.maxPointsSortInHeap) {
            if (this.writer == null) {
                this.switchToOffline();
            }
            this.scratchBytesOutput.reset(this.scratchBytes);
            this.scratchBytesOutput.writeInt(x);
            this.scratchBytesOutput.writeInt(y);
            this.scratchBytesOutput.writeInt(z);
            this.scratchBytesOutput.writeVInt(docID);
            this.scratchBytesOutput.writeVLong(this.pointCount);
            this.writer.write(this.scratchBytes, 0, this.scratchBytes.length);
        } else {
            this.heapWriter.append(x, y, z, this.pointCount, docID);
        }
        ++this.pointCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Writer convertToFixedWidth(Path in) throws IOException {
        Writer sortedWriter;
        block12: {
            OfflineSorter.ByteSequencesReader reader;
            block11: {
                BytesRefBuilder scratch = new BytesRefBuilder();
                scratch.grow(24);
                BytesRef bytes = scratch.get();
                ByteArrayDataInput dataReader = new ByteArrayDataInput();
                reader = null;
                sortedWriter = null;
                boolean success = false;
                try {
                    reader = new OfflineSorter.ByteSequencesReader(in);
                    sortedWriter = this.getWriter(this.pointCount);
                    for (long i = 0L; i < this.pointCount; ++i) {
                        boolean result = reader.read(scratch);
                        assert (result);
                        dataReader.reset(bytes.bytes, bytes.offset, bytes.length);
                        int x = dataReader.readInt();
                        int y = dataReader.readInt();
                        int z = dataReader.readInt();
                        int docID = dataReader.readVInt();
                        long ord = dataReader.readVLong();
                        assert (docID >= 0) : "docID=" + docID;
                        sortedWriter.append(x, y, z, ord, docID);
                    }
                    success = true;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(sortedWriter, reader);
                    } else {
                        IOUtils.closeWhileHandlingException(sortedWriter, reader);
                        try {
                            sortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                IOUtils.close(sortedWriter, reader);
                break block12;
            }
            IOUtils.closeWhileHandlingException(sortedWriter, reader);
            try {
                sortedWriter.destroy();
            }
            catch (Throwable t) {}
        }
        return sortedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Writer sort(final int dim) throws IOException {
        Writer writer;
        block9: {
            Path sorted;
            block8: {
                if (this.heapWriter != null) {
                    assert (this.pointCount < Integer.MAX_VALUE);
                    new InPlaceMergeSorter(){

                        @Override
                        protected void swap(int i, int j) {
                            int docID = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.docIDs[i];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.docIDs[i] = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.docIDs[j];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.docIDs[j] = docID;
                            long ord = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ords[i];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ords[i] = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ords[j];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ords[j] = ord;
                            int x = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.xs[i];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.xs[i] = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.xs[j];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.xs[j] = x;
                            int y = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ys[i];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ys[i] = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ys[j];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ys[j] = y;
                            int z = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.zs[i];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.zs[i] = ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.zs[j];
                            ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.zs[j] = z;
                        }

                        @Override
                        protected int compare(int i, int j) {
                            int cmp = dim == 0 ? Integer.compare(((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.xs[i], ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.xs[j]) : (dim == 1 ? Integer.compare(((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ys[i], ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ys[j]) : Integer.compare(((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.zs[i], ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.zs[j]));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = Integer.compare(((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.docIDs[i], ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.docIDs[j]);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Long.compare(((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ords[i], ((BKD3DTreeWriter)BKD3DTreeWriter.this).heapWriter.ords[j]);
                        }
                    }.sort(0, (int)this.pointCount);
                    HeapWriter sorted2 = new HeapWriter((int)this.pointCount);
                    int i = 0;
                    while ((long)i < this.pointCount) {
                        sorted2.append(this.heapWriter.xs[i], this.heapWriter.ys[i], this.heapWriter.zs[i], this.heapWriter.ords[i], this.heapWriter.docIDs[i]);
                        ++i;
                    }
                    sorted2.close();
                    return sorted2;
                }
                assert (this.tempInput != null);
                final ByteArrayDataInput reader = new ByteArrayDataInput();
                Comparator<BytesRef> cmp = new Comparator<BytesRef>(){
                    private final ByteArrayDataInput readerB = new ByteArrayDataInput();

                    @Override
                    public int compare(BytesRef a, BytesRef b) {
                        reader.reset(a.bytes, a.offset, a.length);
                        int xa = reader.readInt();
                        int ya = reader.readInt();
                        int za = reader.readInt();
                        int docIDA = reader.readVInt();
                        long ordA = reader.readVLong();
                        reader.reset(b.bytes, b.offset, b.length);
                        int xb = reader.readInt();
                        int yb = reader.readInt();
                        int zb = reader.readInt();
                        int docIDB = reader.readVInt();
                        long ordB = reader.readVLong();
                        int cmp = dim == 0 ? Integer.compare(xa, xb) : (dim == 1 ? Integer.compare(ya, yb) : Integer.compare(za, zb));
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = Integer.compare(docIDA, docIDB);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Long.compare(ordA, ordB);
                    }
                };
                sorted = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "sorted", "", new FileAttribute[0]);
                boolean success = false;
                try {
                    OfflineSorter sorter = new OfflineSorter(cmp);
                    sorter.sort(this.tempInput, sorted);
                    Writer writer2 = this.convertToFixedWidth(sorted);
                    success = true;
                    writer = writer2;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.rm(sorted);
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(sorted);
                    }
                    throw throwable;
                }
                IOUtils.rm(sorted);
                break block9;
            }
            IOUtils.deleteFilesIgnoringExceptions(sorted);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish(IndexOutput out) throws IOException {
        int i;
        long[] leafBlockFPs;
        int[] splitValues;
        int numLeaves;
        block23: {
            Writer zSortedWriter;
            Writer ySortedWriter;
            Writer xSortedWriter;
            block22: {
                if (this.writer != null) {
                    this.writer.close();
                }
                LongBitSet bitSet = new LongBitSet(this.pointCount);
                long countPerLeaf = this.pointCount;
                long innerNodeCount = 1L;
                while (countPerLeaf > (long)this.maxPointsInLeafNode) {
                    countPerLeaf = (countPerLeaf + 1L) / 2L;
                    innerNodeCount *= 2L;
                }
                if (1L + 2L * innerNodeCount >= Integer.MAX_VALUE) {
                    throw new IllegalStateException("too many nodes; increase maxPointsInLeafNode (currently " + this.maxPointsInLeafNode + ") and reindex");
                }
                numLeaves = (int)(--innerNodeCount + 1L);
                splitValues = new int[numLeaves];
                leafBlockFPs = new long[numLeaves];
                assert (this.pointCount / (long)splitValues.length <= (long)this.maxPointsInLeafNode) : "pointCount=" + this.pointCount + " splitValues.length=" + splitValues.length + " maxPointsInLeafNode=" + this.maxPointsInLeafNode;
                xSortedWriter = null;
                ySortedWriter = null;
                zSortedWriter = null;
                boolean success = false;
                try {
                    xSortedWriter = this.sort(0);
                    ySortedWriter = this.sort(1);
                    zSortedWriter = this.sort(2);
                    this.heapWriter = null;
                    this.build(1, numLeaves, new PathSlice(xSortedWriter, 0L, this.pointCount), new PathSlice(ySortedWriter, 0L, this.pointCount), new PathSlice(zSortedWriter, 0L, this.pointCount), bitSet, out, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, splitValues, leafBlockFPs);
                    success = true;
                    if (!success) break block22;
                }
                catch (Throwable throwable) {
                    if (success) {
                        xSortedWriter.destroy();
                        ySortedWriter.destroy();
                        zSortedWriter.destroy();
                        IOUtils.rm(this.tempInput);
                    } else {
                        try {
                            xSortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            ySortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            zSortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        IOUtils.deleteFilesIgnoringExceptions(this.tempInput);
                    }
                    throw throwable;
                }
                xSortedWriter.destroy();
                ySortedWriter.destroy();
                zSortedWriter.destroy();
                IOUtils.rm(this.tempInput);
                break block23;
            }
            try {
                xSortedWriter.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                ySortedWriter.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                zSortedWriter.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            IOUtils.deleteFilesIgnoringExceptions(this.tempInput);
        }
        long indexFP = out.getFilePointer();
        out.writeVInt(numLeaves);
        for (i = 0; i < splitValues.length; ++i) {
            out.writeInt(splitValues[i]);
        }
        for (i = 0; i < leafBlockFPs.length; ++i) {
            out.writeVLong(leafBlockFPs[i]);
        }
        return indexFP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int markLeftTree(int splitDim, PathSlice source, LongBitSet bitSet, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) throws IOException {
        int splitValue;
        long leftCount;
        block23: {
            Reader reader;
            block21: {
                boolean success;
                block22: {
                    block20: {
                        leftCount = source.count / 2L;
                        reader = source.writer.getReader(source.start + leftCount);
                        success = false;
                        try {
                            boolean result = reader.next();
                            assert (result);
                            int x = reader.x();
                            assert (x >= minX && x <= maxX) : "x=" + x + " minX=" + minX + " maxX=" + maxX;
                            int y = reader.y();
                            assert (y >= minY && y <= maxY) : "y=" + y + " minY=" + minY + " maxY=" + maxY;
                            int z = reader.z();
                            assert (z >= minZ && z <= maxZ) : "z=" + z + " minZ=" + minZ + " maxZ=" + maxZ;
                            splitValue = splitDim == 0 ? x : (splitDim == 1 ? y : z);
                            success = true;
                            if (!success) break block20;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close(reader);
                            } else {
                                IOUtils.closeWhileHandlingException(reader);
                            }
                            throw throwable;
                        }
                        IOUtils.close(reader);
                        break block22;
                    }
                    IOUtils.closeWhileHandlingException(reader);
                }
                assert (bitSet.cardinality() == 0L) : "cardinality=" + bitSet.cardinality();
                success = false;
                reader = source.writer.getReader(source.start);
                try {
                    int lastValue = Integer.MIN_VALUE;
                    int i = 0;
                    while ((long)i < leftCount) {
                        boolean result = reader.next();
                        assert (result);
                        int x = reader.x();
                        int y = reader.y();
                        int z = reader.z();
                        int value = splitDim == 0 ? x : (splitDim == 1 ? y : z);
                        assert (value >= lastValue);
                        lastValue = value;
                        assert (value <= splitValue) : "i=" + i + " value=" + value + " vs splitValue=" + splitValue;
                        long ord = reader.ord();
                        int docID = reader.docID();
                        assert (docID >= 0) : "docID=" + docID + " reader=" + reader;
                        assert (!bitSet.get(ord));
                        bitSet.set(ord);
                        ++i;
                    }
                    success = true;
                    if (!success) break block21;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(reader);
                    } else {
                        IOUtils.closeWhileHandlingException(reader);
                    }
                    throw throwable;
                }
                IOUtils.close(reader);
                break block23;
            }
            IOUtils.closeWhileHandlingException(reader);
        }
        assert (leftCount == bitSet.cardinality()) : "leftCount=" + leftCount + " cardinality=" + bitSet.cardinality();
        return splitValue;
    }

    static int getSplitDim(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        long xRange = (long)maxX - (long)minX;
        long yRange = (long)maxY - (long)minY;
        long zRange = (long)maxZ - (long)minZ;
        if (xRange > yRange) {
            if (xRange > zRange) {
                return 0;
            }
            return 2;
        }
        if (yRange > zRange) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(int nodeID, int leafNodeOffset, PathSlice lastXSorted, PathSlice lastYSorted, PathSlice lastZSorted, LongBitSet bitSet, IndexOutput out, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int[] splitValues, long[] leafBlockFPs) throws IOException {
        block70: {
            long count;
            block68: {
                block69: {
                    Reader reader;
                    block65: {
                        count = lastXSorted.count;
                        assert (count > 0L);
                        assert (count <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
                        assert (count == lastYSorted.count);
                        assert (count == lastZSorted.count);
                        if (nodeID < leafNodeOffset) break block68;
                        assert (maxX >= minX);
                        assert (maxY >= minY);
                        assert (maxZ >= minZ);
                        reader = lastXSorted.writer.getReader(lastXSorted.start);
                        assert (count <= (long)this.scratchDocIDs.length) : "count=" + count + " scratchDocIDs.length=" + this.scratchDocIDs.length;
                        boolean success = false;
                        try {
                            int i = 0;
                            while ((long)i < count) {
                                boolean result = reader.next();
                                assert (result);
                                this.scratchDocIDs[i] = reader.docID();
                                ++i;
                            }
                            success = true;
                            if (!success) break block65;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close(reader);
                            } else {
                                IOUtils.closeWhileHandlingException(reader);
                            }
                            throw throwable;
                        }
                        IOUtils.close(reader);
                        break block69;
                    }
                    IOUtils.closeWhileHandlingException(reader);
                }
                Arrays.sort(this.scratchDocIDs, 0, (int)count);
                int lastDocID = -1;
                int uniqueCount = 0;
                int i = 0;
                while ((long)i < count) {
                    int docID = this.scratchDocIDs[i];
                    if (docID != lastDocID) {
                        ++uniqueCount;
                        lastDocID = docID;
                    }
                    ++i;
                }
                assert ((long)uniqueCount <= count);
                long startFP = out.getFilePointer();
                out.writeVInt(uniqueCount);
                leafBlockFPs[nodeID - leafNodeOffset] = startFP;
                lastDocID = -1;
                int i2 = 0;
                while ((long)i2 < count) {
                    int docID = this.scratchDocIDs[i2];
                    if (docID != lastDocID) {
                        out.writeInt(docID);
                        lastDocID = docID;
                    }
                    ++i2;
                }
                break block70;
            }
            int splitDim = BKD3DTreeWriter.getSplitDim(minX, maxX, minY, maxY, minZ, maxZ);
            PathSlice source = splitDim == 0 ? lastXSorted : (splitDim == 1 ? lastYSorted : lastZSorted);
            assert (count > 0L);
            assert (nodeID < splitValues.length) : "nodeID=" + nodeID + " splitValues.length=" + splitValues.length;
            int splitValue = this.markLeftTree(splitDim, source, bitSet, minX, maxX, minY, maxY, minZ, maxZ);
            long leftCount = count / 2L;
            Writer[] leftWriters = new Writer[3];
            Writer[] rightWriters = new Writer[3];
            for (int dim = 0; dim < 3; ++dim) {
                int nextLeftCount;
                Writer rightWriter;
                Writer leftWriter;
                block71: {
                    Reader reader;
                    block66: {
                        if (dim == splitDim) continue;
                        leftWriter = null;
                        rightWriter = null;
                        reader = null;
                        boolean success = false;
                        nextLeftCount = 0;
                        PathSlice nextSource = dim == 0 ? lastXSorted : (dim == 1 ? lastYSorted : lastZSorted);
                        try {
                            leftWriter = this.getWriter(leftCount);
                            rightWriter = this.getWriter(nextSource.count - leftCount);
                            assert (nextSource.count == count);
                            reader = nextSource.writer.getReader(nextSource.start);
                            int i = 0;
                            while ((long)i < count) {
                                boolean result = reader.next();
                                assert (result);
                                int x = reader.x();
                                int y = reader.y();
                                int z = reader.z();
                                long ord = reader.ord();
                                int docID = reader.docID();
                                assert (docID >= 0) : "docID=" + docID + " reader=" + reader;
                                if (bitSet.get(ord)) {
                                    if (splitDim == 0) {
                                        assert (x <= splitValue) : "x=" + x + " splitValue=" + splitValue;
                                    } else if (splitDim == 1) {
                                        assert (y <= splitValue) : "y=" + y + " splitValue=" + splitValue;
                                    } else assert (z <= splitValue) : "z=" + z + " splitValue=" + splitValue;
                                    leftWriter.append(x, y, z, ord, docID);
                                    ++nextLeftCount;
                                } else {
                                    if (splitDim == 0) {
                                        assert (x >= splitValue) : "x=" + x + " splitValue=" + splitValue;
                                    } else if (splitDim == 1) {
                                        assert (y >= splitValue) : "y=" + y + " splitValue=" + splitValue;
                                    } else assert (z >= splitValue) : "z=" + z + " splitValue=" + splitValue;
                                    rightWriter.append(x, y, z, ord, docID);
                                }
                                ++i;
                            }
                            success = true;
                            if (!success) break block66;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close(reader, leftWriter, rightWriter);
                            } else {
                                IOUtils.closeWhileHandlingException(reader, leftWriter, rightWriter);
                            }
                            throw throwable;
                        }
                        IOUtils.close(reader, leftWriter, rightWriter);
                        break block71;
                    }
                    IOUtils.closeWhileHandlingException(reader, leftWriter, rightWriter);
                }
                assert (leftCount == (long)nextLeftCount) : "leftCount=" + leftCount + " nextLeftCount=" + nextLeftCount;
                leftWriters[dim] = leftWriter;
                rightWriters[dim] = rightWriter;
            }
            bitSet.clear(0L, this.pointCount);
            long rightCount = count - leftCount;
            boolean success = false;
            try {
                if (splitDim == 0) {
                    this.build(2 * nodeID, leafNodeOffset, new PathSlice(source.writer, source.start, leftCount), new PathSlice(leftWriters[1], 0L, leftCount), new PathSlice(leftWriters[2], 0L, leftCount), bitSet, out, minX, splitValue, minY, maxY, minZ, maxZ, splitValues, leafBlockFPs);
                    leftWriters[1].destroy();
                    leftWriters[2].destroy();
                    this.build(2 * nodeID + 1, leafNodeOffset, new PathSlice(source.writer, source.start + leftCount, rightCount), new PathSlice(rightWriters[1], 0L, rightCount), new PathSlice(rightWriters[2], 0L, rightCount), bitSet, out, splitValue, maxX, minY, maxY, minZ, maxZ, splitValues, leafBlockFPs);
                    rightWriters[1].destroy();
                    rightWriters[2].destroy();
                } else if (splitDim == 1) {
                    this.build(2 * nodeID, leafNodeOffset, new PathSlice(leftWriters[0], 0L, leftCount), new PathSlice(source.writer, source.start, leftCount), new PathSlice(leftWriters[2], 0L, leftCount), bitSet, out, minX, maxX, minY, splitValue, minZ, maxZ, splitValues, leafBlockFPs);
                    leftWriters[0].destroy();
                    leftWriters[2].destroy();
                    this.build(2 * nodeID + 1, leafNodeOffset, new PathSlice(rightWriters[0], 0L, rightCount), new PathSlice(source.writer, source.start + leftCount, rightCount), new PathSlice(rightWriters[2], 0L, rightCount), bitSet, out, minX, maxX, splitValue, maxY, minZ, maxZ, splitValues, leafBlockFPs);
                    rightWriters[0].destroy();
                    rightWriters[2].destroy();
                } else {
                    this.build(2 * nodeID, leafNodeOffset, new PathSlice(leftWriters[0], 0L, leftCount), new PathSlice(leftWriters[1], 0L, leftCount), new PathSlice(source.writer, source.start, leftCount), bitSet, out, minX, maxX, minY, maxY, minZ, splitValue, splitValues, leafBlockFPs);
                    leftWriters[0].destroy();
                    leftWriters[1].destroy();
                    this.build(2 * nodeID + 1, leafNodeOffset, new PathSlice(rightWriters[0], 0L, rightCount), new PathSlice(rightWriters[1], 0L, rightCount), new PathSlice(source.writer, source.start + leftCount, rightCount), bitSet, out, minX, maxX, minY, maxY, splitValue, maxZ, splitValues, leafBlockFPs);
                    rightWriters[0].destroy();
                    rightWriters[1].destroy();
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (Writer writer : leftWriters) {
                        if (writer == null) continue;
                        try {
                            writer.destroy();
                        }
                        catch (Throwable t) {}
                    }
                    for (Writer writer : rightWriters) {
                        if (writer == null) continue;
                        try {
                            writer.destroy();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            splitValues[nodeID] = splitValue;
        }
    }

    Writer getWriter(long count) throws IOException {
        if (count < (long)this.maxPointsSortInHeap) {
            return new HeapWriter((int)count);
        }
        return new OfflineWriter(count);
    }

    private static final class PathSlice {
        final Writer writer;
        final long start;
        final long count;

        public PathSlice(Writer writer, long start, long count) {
            this.writer = writer;
            this.start = start;
            this.count = count;
        }

        public String toString() {
            return "PathSlice(start=" + this.start + " count=" + this.count + " writer=" + this.writer + ")";
        }
    }
}

