/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.IOException;
import org.apache.lucene.bkdtree3d.BKD3DTreeWriter;
import org.apache.lucene.bkdtree3d.Geo3DDocValuesConsumer;
import org.apache.lucene.bkdtree3d.Geo3DDocValuesProducer;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene54.Lucene54DocValuesFormat;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class Geo3DDocValuesFormat
extends DocValuesFormat {
    static final String DATA_CODEC_NAME = "Geo3DData";
    static final int DATA_VERSION_START = 0;
    static final int DATA_VERSION_CURRENT = 0;
    static final String DATA_EXTENSION = "g3dd";
    static final String META_CODEC_NAME = "Geo3DMeta";
    static final int META_VERSION_START = 0;
    static final int META_VERSION_CURRENT = 0;
    static final String META_EXTENSION = "g3dm";
    private final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    private final DocValuesFormat delegate = new Lucene54DocValuesFormat();
    private final PlanetModel planetModel;

    public Geo3DDocValuesFormat() {
        this(PlanetModel.WGS84, 1024, 131072);
    }

    public Geo3DDocValuesFormat(PlanetModel planetModel, int maxPointsInLeafNode, int maxPointsSortInHeap) {
        super("BKD3DTree");
        BKD3DTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.planetModel = planetModel;
    }

    @Override
    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new Geo3DDocValuesConsumer(this.planetModel, this.delegate.fieldsConsumer(state), state, this.maxPointsInLeafNode, this.maxPointsSortInHeap);
    }

    @Override
    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new Geo3DDocValuesProducer(this.delegate.fieldsProducer(state), state);
    }

    static int encodeValueLenient(double planetMax, double x) {
        if (x > planetMax) {
            x = planetMax;
        } else if (x < -planetMax) {
            x = -planetMax;
        }
        return Geo3DDocValuesFormat.encodeValue(planetMax, x);
    }

    static int encodeValue(double planetMax, double x) {
        if (x > planetMax) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (greater than planetMax=" + planetMax + ")");
        }
        if (x < -planetMax) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (less than than -planetMax=" + -planetMax + ")");
        }
        long y = Math.round(x * (2.147483647E9 / planetMax));
        assert (y >= Integer.MIN_VALUE);
        assert (y <= Integer.MAX_VALUE);
        return (int)y;
    }

    static double decodeValueCenter(double planetMax, int x) {
        return (double)x * (planetMax / 2.147483647E9);
    }

    static double decodeValueMin(double planetMax, int x) {
        return ((double)x - 0.5) * (planetMax / 2.147483647E9);
    }

    static double decodeValueMax(double planetMax, int x) {
        return ((double)x + 0.5) * (planetMax / 2.147483647E9);
    }

    static int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    static void writeInt(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >> 24 & 0xFF);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFF);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFF);
        bytes[offset + 3] = (byte)(value & 0xFF);
    }
}

