/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

public class PayloadScoreQuery
extends SpanQuery {
    private final SpanQuery wrappedQuery;
    private final PayloadFunction function;
    private final boolean includeSpanScore;

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, boolean includeSpanScore) {
        this.wrappedQuery = wrappedQuery;
        this.function = function;
        this.includeSpanScore = includeSpanScore;
    }

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function) {
        this(wrappedQuery, function, true);
    }

    @Override
    public String getField() {
        return this.wrappedQuery.getField();
    }

    @Override
    public String toString(String field) {
        return "PayloadSpanQuery[" + this.wrappedQuery.toString(field) + "; " + this.function.toString() + "]";
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight innerWeight = this.wrappedQuery.createWeight(searcher, needsScores);
        if (!needsScores) {
            return innerWeight;
        }
        return new PayloadSpanWeight(searcher, innerWeight);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayloadScoreQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayloadScoreQuery that = (PayloadScoreQuery)o;
        if (this.wrappedQuery != null ? !this.wrappedQuery.equals(that.wrappedQuery) : that.wrappedQuery != null) {
            return false;
        }
        return !(this.function == null ? that.function != null : !this.function.equals(that.function));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.wrappedQuery != null ? this.wrappedQuery.hashCode() : 0);
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        return result;
    }

    private class PayloadSpans
    extends Spans
    implements SpanCollector {
        private int payloadsSeen;
        private float payloadScore;
        private final Spans in;

        private PayloadSpans(Spans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
            super(weight, docScorer);
            this.in = spans;
        }

        @Override
        public int nextStartPosition() throws IOException {
            return this.in.nextStartPosition();
        }

        @Override
        public int startPosition() {
            return this.in.startPosition();
        }

        @Override
        public int endPosition() {
            return this.in.endPosition();
        }

        @Override
        public int width() {
            return this.in.width();
        }

        @Override
        public void collect(SpanCollector collector) throws IOException {
            this.in.collect(collector);
        }

        @Override
        protected void doStartCurrentDoc() {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        @Override
        protected void doCurrentSpans() throws IOException {
            this.in.collect(this);
        }

        @Override
        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            if (payload == null) {
                return;
            }
            float payloadFactor = this.docScorer.computePayloadFactor(this.docID(), this.in.startPosition(), this.in.endPosition(), payload);
            this.payloadScore = PayloadScoreQuery.this.function.currentScore(this.docID(), PayloadScoreQuery.this.getField(), this.in.startPosition(), this.in.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
            ++this.payloadsSeen;
        }

        protected float getPayloadScore() {
            return PayloadScoreQuery.this.function.docScore(this.docID(), PayloadScoreQuery.this.getField(), this.payloadsSeen, this.payloadScore);
        }

        protected Explanation getPayloadExplanation() {
            return PayloadScoreQuery.this.function.explain(this.docID(), PayloadScoreQuery.this.getField(), this.payloadsSeen, this.payloadScore);
        }

        protected float getSpanScore() throws IOException {
            return super.scoreCurrentDoc();
        }

        @Override
        protected float scoreCurrentDoc() throws IOException {
            if (PayloadScoreQuery.this.includeSpanScore) {
                return this.getSpanScore() * this.getPayloadScore();
            }
            return this.getPayloadScore();
        }

        @Override
        public void reset() {
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.in.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public float positionsCost() {
            return this.in.positionsCost();
        }
    }

    private class PayloadSpanWeight
    extends SpanWeight {
        private final SpanWeight innerWeight;

        public PayloadSpanWeight(IndexSearcher searcher, SpanWeight innerWeight) throws IOException {
            super(PayloadScoreQuery.this, searcher, null);
            this.innerWeight = innerWeight;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.innerWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
            return this.innerWeight.getSpans(ctx, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            return new PayloadSpans(spans, this, this.innerWeight.getSimScorer(context));
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.innerWeight.extractTerms(terms);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.innerWeight.getValueForNormalization();
        }

        @Override
        public void normalize(float queryNorm, float topLevelBoost) {
            this.innerWeight.normalize(queryNorm, topLevelBoost);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            PayloadSpans scorer = (PayloadSpans)this.scorer(context);
            if (scorer == null || scorer.advance(doc) != doc) {
                return Explanation.noMatch("No match", new Explanation[0]);
            }
            scorer.freq();
            Explanation payloadExpl = scorer.getPayloadExplanation();
            if (PayloadScoreQuery.this.includeSpanScore) {
                SpanWeight innerWeight = ((PayloadSpanWeight)scorer.getWeight()).innerWeight;
                Explanation innerExpl = innerWeight.explain(context, doc);
                return Explanation.match(scorer.scoreCurrentDoc(), "PayloadSpanQuery, product of:", innerExpl, payloadExpl);
            }
            return scorer.getPayloadExplanation();
        }
    }
}

