/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ExistsFieldQueryExtension;
import org.apache.lucene.queryparser.classic.FieldQueryExtension;
import org.apache.lucene.queryparser.classic.MissingFieldQueryExtension;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MapperQueryParser
extends QueryParser {
    public static final ImmutableMap<String, FieldQueryExtension> fieldQueryExtensions = ImmutableMap.builder().put("_exists_", new ExistsFieldQueryExtension()).put("_missing_", (ExistsFieldQueryExtension)((Object)new MissingFieldQueryExtension())).build();
    private final QueryParseContext parseContext;
    private QueryParserSettings settings;
    private Analyzer quoteAnalyzer;
    private boolean forcedAnalyzer;
    private boolean forcedQuoteAnalyzer;
    private MappedFieldType currentFieldType;
    private boolean analyzeWildcard;
    private String quoteFieldSuffix;

    public MapperQueryParser(QueryParseContext parseContext) {
        super(null, null);
        this.parseContext = parseContext;
    }

    public void reset(QueryParserSettings settings) {
        this.settings = settings;
        this.field = settings.defaultField();
        if (settings.fields() != null) {
            this.field = settings.fields.size() == 1 ? settings.fields().get(0) : null;
        }
        this.forcedAnalyzer = settings.forcedAnalyzer() != null;
        this.setAnalyzer(this.forcedAnalyzer ? settings.forcedAnalyzer() : settings.defaultAnalyzer());
        if (settings.forcedQuoteAnalyzer() != null) {
            this.forcedQuoteAnalyzer = true;
            this.quoteAnalyzer = settings.forcedQuoteAnalyzer();
        } else if (this.forcedAnalyzer) {
            this.forcedQuoteAnalyzer = true;
            this.quoteAnalyzer = settings.forcedAnalyzer();
        } else {
            this.forcedAnalyzer = false;
            this.quoteAnalyzer = settings.defaultQuoteAnalyzer();
        }
        this.quoteFieldSuffix = settings.quoteFieldSuffix();
        this.setMultiTermRewriteMethod(settings.rewriteMethod());
        this.setEnablePositionIncrements(settings.enablePositionIncrements());
        this.setAutoGeneratePhraseQueries(settings.autoGeneratePhraseQueries());
        this.setMaxDeterminizedStates(settings.maxDeterminizedStates());
        this.setAllowLeadingWildcard(settings.allowLeadingWildcard());
        this.setLowercaseExpandedTerms(settings.lowercaseExpandedTerms());
        this.setPhraseSlop(settings.phraseSlop());
        this.setDefaultOperator(settings.defaultOperator());
        this.setFuzzyMinSim(settings.getFuzziness().asFloat());
        this.setFuzzyPrefixLength(settings.fuzzyPrefixLength());
        this.setLocale(settings.locale());
        this.analyzeWildcard = settings.analyzeWildcard();
    }

    @Override
    Query handleBareFuzzy(String qfield, Token fuzzySlop, String termImage) throws ParseException {
        if (fuzzySlop.image.length() == 1) {
            return this.getFuzzyQuery(qfield, termImage, Float.toString(this.fuzzyMinSim));
        }
        return this.getFuzzyQuery(qfield, termImage, fuzzySlop.image.substring(1));
    }

    @Override
    protected Query newTermQuery(Term term) {
        Query termQuery;
        if (this.currentFieldType != null && (termQuery = this.currentFieldType.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return super.newTermQuery(term);
    }

    @Override
    protected Query newMatchAllDocsQuery() {
        return Queries.newMatchAllQuery();
    }

    @Override
    public Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        FieldQueryExtension fieldQueryExtension = fieldQueryExtensions.get(field);
        if (fieldQueryExtension != null) {
            return fieldQueryExtension.query(this.parseContext, queryText);
        }
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getFieldQuerySingle(fields.iterator().next(), queryText, quoted);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getFieldQuerySingle(mField, queryText, quoted);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getFieldQuerySingle(mField, queryText, quoted);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getFieldQuerySingle(field, queryText, quoted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query getFieldQuerySingle(String field, String queryText, boolean quoted) throws ParseException {
        if (!quoted && queryText.length() > 1) {
            if (queryText.charAt(0) == '>') {
                if (queryText.length() <= 2) return this.getRangeQuerySingle(field, queryText.substring(1), null, false, true);
                if (queryText.charAt(1) != '=') return this.getRangeQuerySingle(field, queryText.substring(1), null, false, true);
                return this.getRangeQuerySingle(field, queryText.substring(2), null, true, true);
            }
            if (queryText.charAt(0) == '<') {
                if (queryText.length() <= 2) return this.getRangeQuerySingle(field, null, queryText.substring(1), true, false);
                if (queryText.charAt(1) != '=') return this.getRangeQuerySingle(field, null, queryText.substring(1), true, false);
                return this.getRangeQuerySingle(field, null, queryText.substring(2), true, true);
            }
        }
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            if (quoted) {
                this.setAnalyzer(this.quoteAnalyzer);
                if (this.quoteFieldSuffix != null) {
                    this.currentFieldType = this.parseContext.fieldMapper(field + this.quoteFieldSuffix);
                }
            }
            if (this.currentFieldType == null) {
                this.currentFieldType = this.parseContext.fieldMapper(field);
            }
            if (this.currentFieldType != null) {
                if (quoted) {
                    if (!this.forcedQuoteAnalyzer) {
                        this.setAnalyzer(this.parseContext.getSearchQuoteAnalyzer(this.currentFieldType));
                    }
                } else if (!this.forcedAnalyzer) {
                    this.setAnalyzer(this.parseContext.getSearchAnalyzer(this.currentFieldType));
                }
                if (this.currentFieldType != null) {
                    Query query = null;
                    if (this.currentFieldType.useTermQueryWithQueryString()) {
                        try {
                            query = this.currentFieldType.termQuery(queryText, this.parseContext);
                        }
                        catch (RuntimeException e) {
                            if (!this.settings.lenient()) throw e;
                            Query query2 = null;
                            this.setAnalyzer(oldAnalyzer);
                            return query2;
                        }
                    }
                    if (query == null) {
                        query = super.getFieldQuery(this.currentFieldType.names().indexName(), queryText, quoted);
                    }
                    Query query3 = query;
                    return query3;
                }
            }
            Query query = super.getFieldQuery(field, queryText, quoted);
            return query;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields) {
                    Query q = super.getFieldQuery(mField, queryText, slop);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    q = this.applySlop(q, slop);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = super.getFieldQuery(mField, queryText, slop);
                if (q == null) continue;
                this.applyBoost(mField, q);
                q = this.applySlop(q, slop);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFieldQuery(field, queryText, slop);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Collection<String> fields;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        if ((fields = this.extractMultiFields(field)) == null) {
            return this.getRangeQuerySingle(field, part1, part2, startInclusive, endInclusive);
        }
        if (fields.size() == 1) {
            return this.getRangeQuerySingle(fields.iterator().next(), part1, part2, startInclusive, endInclusive);
        }
        if (this.settings.useDisMax()) {
            DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
            boolean added = false;
            for (String mField : fields) {
                Query q = this.getRangeQuerySingle(mField, part1, part2, startInclusive, endInclusive);
                if (q == null) continue;
                added = true;
                this.applyBoost(mField, q);
                disMaxQuery.add(q);
            }
            if (!added) {
                return null;
            }
            return disMaxQuery;
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String mField : fields) {
            Query q = this.getRangeQuerySingle(mField, part1, part2, startInclusive, endInclusive);
            if (q == null) continue;
            this.applyBoost(mField, q);
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
        if (clauses.size() == 0) {
            return null;
        }
        return this.getBooleanQuery(clauses, true);
    }

    private Query getRangeQuerySingle(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        this.currentFieldType = this.parseContext.fieldMapper(field);
        if (this.currentFieldType != null) {
            if (this.lowercaseExpandedTerms && !this.currentFieldType.isNumeric()) {
                part1 = part1 == null ? null : part1.toLowerCase(this.locale);
                part2 = part2 == null ? null : part2.toLowerCase(this.locale);
            }
            try {
                Query rangeQuery;
                if (this.currentFieldType instanceof DateFieldMapper.DateFieldType && this.settings.timeZone() != null) {
                    DateFieldMapper.DateFieldType dateFieldType = (DateFieldMapper.DateFieldType)this.currentFieldType;
                    rangeQuery = dateFieldType.rangeQuery(part1, part2, startInclusive, endInclusive, this.settings.timeZone(), null);
                } else {
                    rangeQuery = this.currentFieldType.rangeQuery(part1, part2, startInclusive, endInclusive);
                }
                return rangeQuery;
            }
            catch (RuntimeException e) {
                if (this.settings.lenient()) {
                    return null;
                }
                throw e;
            }
        }
        return this.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    protected Query getFuzzyQuery(String field, String termStr, String minSimilarity) throws ParseException {
        Collection<String> fields;
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        if ((fields = this.extractMultiFields(field)) != null) {
            if (fields.size() == 1) {
                return this.getFuzzyQuerySingle(fields.iterator().next(), termStr, minSimilarity);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getFuzzyQuerySingle(mField, termStr, minSimilarity);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getFuzzyQuerySingle(mField, termStr, minSimilarity);
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getFuzzyQuerySingle(field, termStr, minSimilarity);
    }

    private Query getFuzzyQuerySingle(String field, String termStr, String minSimilarity) throws ParseException {
        this.currentFieldType = this.parseContext.fieldMapper(field);
        if (this.currentFieldType != null) {
            try {
                return this.currentFieldType.fuzzyQuery(termStr, Fuzziness.build(minSimilarity), this.fuzzyPrefixLength, this.settings.fuzzyMaxExpansions(), true);
            }
            catch (RuntimeException e) {
                if (this.settings.lenient()) {
                    return null;
                }
                throw e;
            }
        }
        return super.getFuzzyQuery(field, termStr, Float.parseFloat(minSimilarity));
    }

    @Override
    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        String text = term.text();
        int numEdits = FuzzyQuery.floatToEdits(minimumSimilarity, text.codePointCount(0, text.length()));
        FuzzyQuery query = new FuzzyQuery(term, numEdits, prefixLength, this.settings.fuzzyMaxExpansions(), true);
        QueryParsers.setRewriteMethod(query, this.settings.fuzzyRewriteMethod());
        return query;
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        Collection<String> fields;
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        if ((fields = this.extractMultiFields(field)) != null) {
            if (fields.size() == 1) {
                return this.getPrefixQuerySingle(fields.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getPrefixQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getPrefixQuerySingle(mField, termStr);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getPrefixQuerySingle(field, termStr);
    }

    private Query getPrefixQuerySingle(String field, String termStr) throws ParseException {
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            this.currentFieldType = this.parseContext.fieldMapper(field);
            if (this.currentFieldType != null) {
                if (!this.forcedAnalyzer) {
                    this.setAnalyzer(this.parseContext.getSearchAnalyzer(this.currentFieldType));
                }
                Query query = null;
                if (this.currentFieldType.useTermQueryWithQueryString()) {
                    query = this.currentFieldType.prefixQuery(termStr, this.multiTermRewriteMethod, this.parseContext);
                }
                if (query == null) {
                    query = this.getPossiblyAnalyzedPrefixQuery(this.currentFieldType.names().indexName(), termStr);
                }
                Query query2 = query;
                return query2;
            }
            Query query = this.getPossiblyAnalyzedPrefixQuery(field, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query getPossiblyAnalyzedPrefixQuery(String field, String termStr) throws ParseException {
        ArrayList<String> tlist;
        block17: {
            if (!this.analyzeWildcard) {
                return super.getPrefixQuery(field, termStr);
            }
            TokenStream source = null;
            try {
                try {
                    source = this.getAnalyzer().tokenStream(field, termStr);
                    source.reset();
                }
                catch (IOException e) {
                    Query query = super.getPrefixQuery(field, termStr);
                    if (source != null) {
                        IOUtils.closeWhileHandlingException(source);
                    }
                    return query;
                }
            }
            catch (Throwable throwable) {
                if (source != null) {
                    IOUtils.closeWhileHandlingException(source);
                }
                throw throwable;
            }
            {
                tlist = new ArrayList<String>();
                CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
                while (true) {
                    block16: {
                        try {
                            if (!source.incrementToken()) {
                            }
                            break block16;
                        }
                        catch (IOException e) {}
                        if (source != null) {
                            break;
                        }
                        break block17;
                    }
                    tlist.add(termAtt.toString());
                }
            }
            IOUtils.closeWhileHandlingException(source);
        }
        if (tlist.size() == 1) {
            return super.getPrefixQuery(field, (String)tlist.get(0));
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        Iterator i$ = tlist.iterator();
        while (i$.hasNext()) {
            String token = (String)i$.next();
            clauses.add(new BooleanClause(super.getPrefixQuery(field, token), BooleanClause.Occur.SHOULD));
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        Collection<String> fields;
        if (termStr.equals("*") && ("*".equals(field) || Objects.equals(field, this.field))) {
            String actualField = field;
            if (actualField == null) {
                actualField = this.field;
            }
            if (actualField == null) {
                return this.newMatchAllDocsQuery();
            }
            if ("*".equals(actualField) || "_all".equals(actualField)) {
                return this.newMatchAllDocsQuery();
            }
            return fieldQueryExtensions.get("_exists_").query(this.parseContext, actualField);
        }
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        if ((fields = this.extractMultiFields(field)) != null) {
            if (fields.size() == 1) {
                return this.getWildcardQuerySingle(fields.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getWildcardQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getWildcardQuerySingle(mField, termStr);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getWildcardQuerySingle(field, termStr);
    }

    private Query getWildcardQuerySingle(String field, String termStr) throws ParseException {
        String indexedNameField = field;
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            this.currentFieldType = this.parseContext.fieldMapper(field);
            if (this.currentFieldType != null) {
                if (!this.forcedAnalyzer) {
                    this.setAnalyzer(this.parseContext.getSearchAnalyzer(this.currentFieldType));
                }
                indexedNameField = this.currentFieldType.names().indexName();
                Query query = this.getPossiblyAnalyzedWildcardQuery(indexedNameField, termStr);
                return query;
            }
            Query query = this.getPossiblyAnalyzedWildcardQuery(indexedNameField, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    private Query getPossiblyAnalyzedWildcardQuery(String field, String termStr) throws ParseException {
        if (!this.analyzeWildcard) {
            return super.getWildcardQuery(field, termStr);
        }
        boolean isWithinToken = !termStr.startsWith("?") && !termStr.startsWith("*");
        StringBuilder aggStr = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < termStr.length(); ++i) {
            char c = termStr.charAt(i);
            if (c == '?' || c == '*') {
                if (isWithinToken) {
                    try (TokenStream source = this.getAnalyzer().tokenStream(field, tmp.toString());){
                        source.reset();
                        CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
                        if (source.incrementToken()) {
                            String term = termAtt.toString();
                            if (term.length() == 0) {
                                aggStr.append((CharSequence)tmp);
                            } else {
                                aggStr.append(term);
                            }
                        } else {
                            aggStr.append((CharSequence)tmp);
                        }
                    }
                    catch (IOException e) {
                        aggStr.append((CharSequence)tmp);
                    }
                    tmp.setLength(0);
                }
                isWithinToken = false;
                aggStr.append(c);
                continue;
            }
            tmp.append(c);
            isWithinToken = true;
        }
        if (isWithinToken) {
            try (TokenStream source = this.getAnalyzer().tokenStream(field, tmp.toString());){
                source.reset();
                CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
                if (source.incrementToken()) {
                    String term = termAtt.toString();
                    if (term.length() == 0) {
                        aggStr.append((CharSequence)tmp);
                    } else {
                        aggStr.append(term);
                    }
                } else {
                    aggStr.append((CharSequence)tmp);
                }
            }
            catch (IOException e) {
                aggStr.append((CharSequence)tmp);
            }
        }
        return super.getWildcardQuery(field, aggStr.toString());
    }

    @Override
    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        Collection<String> fields;
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        if ((fields = this.extractMultiFields(field)) != null) {
            if (fields.size() == 1) {
                return this.getRegexpQuerySingle(fields.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getRegexpQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getRegexpQuerySingle(mField, termStr);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getRegexpQuerySingle(field, termStr);
    }

    private Query getRegexpQuerySingle(String field, String termStr) throws ParseException {
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            this.currentFieldType = this.parseContext.fieldMapper(field);
            if (this.currentFieldType != null) {
                if (!this.forcedAnalyzer) {
                    this.setAnalyzer(this.parseContext.getSearchAnalyzer(this.currentFieldType));
                }
                Query query = null;
                if (this.currentFieldType.useTermQueryWithQueryString()) {
                    query = this.currentFieldType.regexpQuery(termStr, 65535, this.maxDeterminizedStates, this.multiTermRewriteMethod, this.parseContext);
                }
                if (query == null) {
                    query = super.getRegexpQuery(field, termStr);
                }
                Query query2 = query;
                return query2;
            }
            Query query = super.getRegexpQuery(field, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    @Override
    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        Query q = super.getBooleanQuery(clauses, disableCoord);
        if (q == null) {
            return null;
        }
        return Queries.fixNegativeQueryIfNeeded(q);
    }

    private void applyBoost(String field, Query q) {
        if (this.settings.boosts() != null) {
            float boost = this.settings.boosts().getOrDefault(field, 1.0f);
            q.setBoost(boost);
        }
    }

    private Query applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            PhraseQuery pq = (PhraseQuery)q;
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            pq = builder.build();
            pq.setBoost(q.getBoost());
            return pq;
        }
        if (q instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)q).setSlop(slop);
            return q;
        }
        return q;
    }

    private Collection<String> extractMultiFields(String field) {
        Collection<String> fields = null;
        fields = field != null ? this.parseContext.simpleMatchToIndexNames(field) : this.settings.fields();
        return fields;
    }

    @Override
    public Query parse(String query) throws ParseException {
        if (query.trim().isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return super.parse(query);
    }
}

