/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ToStringUtils;

public class GeoPointInBBoxQuery
extends Query {
    protected final String field;
    protected final double minLon;
    protected final double minLat;
    protected final double maxLon;
    protected final double maxLat;

    public GeoPointInBBoxQuery(String field, double minLon, double minLat, double maxLon, double maxLat) {
        this.field = field;
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.maxLat = maxLat;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        if (this.minLon == -180.0 && this.maxLon == 180.0 && this.minLat == -90.0 && this.maxLat == 90.0) {
            return new FieldValueQuery(this.field);
        }
        if (this.maxLon < this.minLon) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            GeoPointInBBoxQueryImpl left = new GeoPointInBBoxQueryImpl(this.field, -180.0, this.minLat, this.maxLon, this.maxLat);
            bq.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
            GeoPointInBBoxQueryImpl right = new GeoPointInBBoxQueryImpl(this.field, this.minLon, this.minLat, 180.0, this.maxLat);
            bq.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
            return bq.build();
        }
        return new GeoPointInBBoxQueryImpl(this.field, this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Lower Left: [").append(this.minLon).append(',').append(this.minLat).append(']').append(" Upper Right: [").append(this.maxLon).append(',').append(this.maxLat).append("]").append(ToStringUtils.boost(this.getBoost())).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointInBBoxQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInBBoxQuery that = (GeoPointInBBoxQuery)o;
        if (Double.compare(that.maxLat, this.maxLat) != 0) {
            return false;
        }
        if (Double.compare(that.maxLon, this.maxLon) != 0) {
            return false;
        }
        if (Double.compare(that.minLat, this.minLat) != 0) {
            return false;
        }
        if (Double.compare(that.minLon, this.minLon) != 0) {
            return false;
        }
        return this.field.equals(that.field);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public final String getField() {
        return this.field;
    }

    public final double getMinLon() {
        return this.minLon;
    }

    public final double getMinLat() {
        return this.minLat;
    }

    public final double getMaxLon() {
        return this.maxLon;
    }

    public final double getMaxLat() {
        return this.maxLat;
    }
}

