/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.GeoPointTermQueryConstantScoreWrapper;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.GeoUtils;

abstract class GeoPointTermQuery
extends MultiTermQuery {
    protected final double minLon;
    protected final double minLat;
    protected final double maxLon;
    protected final double maxLat;
    public static final MultiTermQuery.RewriteMethod GEO_CONSTANT_SCORE_REWRITE = new MultiTermQuery.RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new GeoPointTermQueryConstantScoreWrapper<GeoPointTermQuery>((GeoPointTermQuery)query);
        }
    };

    public GeoPointTermQuery(String field, double minLon, double minLat, double maxLon, double maxLat) {
        super(field);
        if (!GeoUtils.isValidLon(minLon)) {
            throw new IllegalArgumentException("invalid minLon " + minLon);
        }
        if (!GeoUtils.isValidLon(maxLon)) {
            throw new IllegalArgumentException("invalid maxLon " + maxLon);
        }
        if (!GeoUtils.isValidLat(minLat)) {
            throw new IllegalArgumentException("invalid minLat " + minLat);
        }
        if (!GeoUtils.isValidLat(maxLat)) {
            throw new IllegalArgumentException("invalid maxLat " + maxLat);
        }
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.maxLat = maxLat;
        this.rewriteMethod = GEO_CONSTANT_SCORE_REWRITE;
    }
}

