/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.GroupDocs;

public class TopGroups<GROUP_VALUE_TYPE> {
    public final int totalHitCount;
    public final int totalGroupedHitCount;
    public final Integer totalGroupCount;
    public final GroupDocs<GROUP_VALUE_TYPE>[] groups;
    public final SortField[] groupSort;
    public final SortField[] withinGroupSort;
    public final float maxScore;

    public TopGroups(SortField[] groupSort, SortField[] withinGroupSort, int totalHitCount, int totalGroupedHitCount, GroupDocs<GROUP_VALUE_TYPE>[] groups, float maxScore) {
        this.groupSort = groupSort;
        this.withinGroupSort = withinGroupSort;
        this.totalHitCount = totalHitCount;
        this.totalGroupedHitCount = totalGroupedHitCount;
        this.groups = groups;
        this.totalGroupCount = null;
        this.maxScore = maxScore;
    }

    public TopGroups(TopGroups<GROUP_VALUE_TYPE> oldTopGroups, Integer totalGroupCount) {
        this.groupSort = oldTopGroups.groupSort;
        this.withinGroupSort = oldTopGroups.withinGroupSort;
        this.totalHitCount = oldTopGroups.totalHitCount;
        this.totalGroupedHitCount = oldTopGroups.totalGroupedHitCount;
        this.groups = oldTopGroups.groups;
        this.maxScore = oldTopGroups.maxScore;
        this.totalGroupCount = totalGroupCount;
    }

    public static <T> TopGroups<T> merge(TopGroups<T>[] shardGroups, Sort groupSort, Sort docSort, int docOffset, int docTopN, ScoreMergeMode scoreMergeMode) throws IOException {
        if (shardGroups.length == 0) {
            return null;
        }
        int totalHitCount = 0;
        int totalGroupedHitCount = 0;
        Integer totalGroupCount = null;
        int numGroups = shardGroups[0].groups.length;
        for (TopGroups<T> shard : shardGroups) {
            if (numGroups != shard.groups.length) {
                throw new IllegalArgumentException("number of groups differs across shards; you must pass same top groups to all shards' second-pass collector");
            }
            totalHitCount += shard.totalHitCount;
            totalGroupedHitCount += shard.totalGroupedHitCount;
            if (shard.totalGroupCount == null) continue;
            if (totalGroupCount == null) {
                totalGroupCount = 0;
            }
            totalGroupCount = totalGroupCount + shard.totalGroupCount;
        }
        GroupDocs[] mergedGroupDocs = new GroupDocs[numGroups];
        TopDocs[] shardTopDocs = docSort == null ? new TopDocs[shardGroups.length] : new TopFieldDocs[shardGroups.length];
        float totalMaxScore = Float.MIN_VALUE;
        for (int groupIDX = 0; groupIDX < numGroups; ++groupIDX) {
            float groupScore;
            ScoreDoc[] mergedScoreDocs;
            Object groupValue = shardGroups[0].groups[groupIDX].groupValue;
            float maxScore = Float.MIN_VALUE;
            int totalHits = 0;
            double scoreSum = 0.0;
            for (int shardIDX = 0; shardIDX < shardGroups.length; ++shardIDX) {
                TopGroups<T> shard = shardGroups[shardIDX];
                GroupDocs shardGroupDocs = shard.groups[groupIDX];
                if (groupValue == null ? shardGroupDocs.groupValue != null : !groupValue.equals(shardGroupDocs.groupValue)) {
                    throw new IllegalArgumentException("group values differ across shards; you must pass same top groups to all shards' second-pass collector");
                }
                shardTopDocs[shardIDX] = docSort == null ? new TopDocs(shardGroupDocs.totalHits, shardGroupDocs.scoreDocs, shardGroupDocs.maxScore) : new TopFieldDocs(shardGroupDocs.totalHits, shardGroupDocs.scoreDocs, docSort.getSort(), shardGroupDocs.maxScore);
                maxScore = Math.max(maxScore, shardGroupDocs.maxScore);
                totalHits += shardGroupDocs.totalHits;
                scoreSum += (double)shardGroupDocs.score;
            }
            TopDocs mergedTopDocs = docSort == null ? TopDocs.merge(docOffset + docTopN, shardTopDocs) : TopDocs.merge(docSort, docOffset + docTopN, (TopFieldDocs[])shardTopDocs);
            if (docOffset == 0) {
                mergedScoreDocs = mergedTopDocs.scoreDocs;
            } else if (docOffset >= mergedTopDocs.scoreDocs.length) {
                mergedScoreDocs = new ScoreDoc[]{};
            } else {
                mergedScoreDocs = new ScoreDoc[mergedTopDocs.scoreDocs.length - docOffset];
                System.arraycopy(mergedTopDocs.scoreDocs, docOffset, mergedScoreDocs, 0, mergedTopDocs.scoreDocs.length - docOffset);
            }
            switch (scoreMergeMode) {
                case None: {
                    groupScore = Float.NaN;
                    break;
                }
                case Avg: {
                    if (totalHits > 0) {
                        groupScore = (float)(scoreSum / (double)totalHits);
                        break;
                    }
                    groupScore = Float.NaN;
                    break;
                }
                case Total: {
                    groupScore = (float)scoreSum;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't handle ScoreMergeMode " + (Object)((Object)scoreMergeMode));
                }
            }
            mergedGroupDocs[groupIDX] = new GroupDocs(groupScore, maxScore, totalHits, mergedScoreDocs, groupValue, shardGroups[0].groups[groupIDX].groupSortValues);
            totalMaxScore = Math.max(totalMaxScore, maxScore);
        }
        if (totalGroupCount != null) {
            TopGroups result = new TopGroups(groupSort.getSort(), docSort == null ? null : docSort.getSort(), totalHitCount, totalGroupedHitCount, mergedGroupDocs, totalMaxScore);
            return new TopGroups(result, totalGroupCount);
        }
        return new TopGroups(groupSort.getSort(), docSort == null ? null : docSort.getSort(), totalHitCount, totalGroupedHitCount, mergedGroupDocs, totalMaxScore);
    }

    public static enum ScoreMergeMode {
        None,
        Total,
        Avg;

    }
}

