/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

abstract class BaseGlobalOrdinalScorer
extends Scorer {
    final SortedDocValues values;
    final Scorer approximationScorer;
    float score;

    public BaseGlobalOrdinalScorer(Weight weight, SortedDocValues values, Scorer approximationScorer) {
        super(weight);
        this.values = values;
        this.approximationScorer = approximationScorer;
    }

    @Override
    public float score() throws IOException {
        return this.score;
    }

    @Override
    public int docID() {
        return this.approximationScorer.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.approximationScorer.docID() + 1);
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int docID() {
                return BaseGlobalOrdinalScorer.this.approximationScorer.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                return BaseGlobalOrdinalScorer.this.approximationScorer.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return BaseGlobalOrdinalScorer.this.approximationScorer.advance(target);
            }

            @Override
            public long cost() {
                return BaseGlobalOrdinalScorer.this.approximationScorer.cost();
            }
        };
        return this.createTwoPhaseIterator(approximation);
    }

    @Override
    public long cost() {
        return this.approximationScorer.cost();
    }

    @Override
    public int freq() throws IOException {
        return 1;
    }

    protected abstract TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator var1);
}

