/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsWithScoreCollector
extends SimpleCollector {
    private static final int INITIAL_ARRAY_SIZE = 0;
    final String field;
    final BytesRefHash collectedTerms = new BytesRefHash();
    final ScoreMode scoreMode;
    Scorer scorer;
    float[] scoreSums = new float[0];

    TermsWithScoreCollector(String field, ScoreMode scoreMode) {
        this.field = field;
        this.scoreMode = scoreMode;
        if (scoreMode == ScoreMode.Min) {
            Arrays.fill(this.scoreSums, Float.POSITIVE_INFINITY);
        } else if (scoreMode == ScoreMode.Max) {
            Arrays.fill(this.scoreSums, Float.NEGATIVE_INFINITY);
        }
    }

    public BytesRefHash getCollectedTerms() {
        return this.collectedTerms;
    }

    public float[] getScoresPerTerm() {
        return this.scoreSums;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    static TermsWithScoreCollector create(String field, boolean multipleValuesPerDocument, ScoreMode scoreMode) {
        if (multipleValuesPerDocument) {
            switch (scoreMode) {
                case Avg: {
                    return new MV.Avg(field);
                }
            }
            return new MV(field, scoreMode);
        }
        switch (scoreMode) {
            case Avg: {
                return new SV.Avg(field);
            }
        }
        return new SV(field, scoreMode);
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    static class MV
    extends TermsWithScoreCollector {
        SortedSetDocValues fromDocTermOrds;

        MV(String field, ScoreMode scoreMode) {
            super(field, scoreMode);
        }

        @Override
        public void collect(int doc) throws IOException {
            long ord;
            this.fromDocTermOrds.setDocument(doc);
            while ((ord = this.fromDocTermOrds.nextOrd()) != -1L) {
                int termID = this.collectedTerms.add(this.fromDocTermOrds.lookupOrd(ord));
                if (termID < 0) {
                    termID = -termID - 1;
                } else if (termID >= this.scoreSums.length) {
                    int begin = this.scoreSums.length;
                    this.scoreSums = ArrayUtil.grow(this.scoreSums);
                    if (this.scoreMode == ScoreMode.Min) {
                        Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.POSITIVE_INFINITY);
                    } else if (this.scoreMode == ScoreMode.Max) {
                        Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.NEGATIVE_INFINITY);
                    }
                }
                switch (this.scoreMode) {
                    case Total: {
                        int n = termID;
                        this.scoreSums[n] = this.scoreSums[n] + this.scorer.score();
                        break;
                    }
                    case Min: {
                        this.scoreSums[termID] = Math.min(this.scoreSums[termID], this.scorer.score());
                        break;
                    }
                    case Max: {
                        this.scoreSums[termID] = Math.max(this.scoreSums[termID], this.scorer.score());
                    }
                }
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.fromDocTermOrds = DocValues.getSortedSet(context.reader(), this.field);
        }

        static class Avg
        extends MV {
            int[] scoreCounts = new int[0];

            Avg(String field) {
                super(field, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                long ord;
                this.fromDocTermOrds.setDocument(doc);
                while ((ord = this.fromDocTermOrds.nextOrd()) != -1L) {
                    int termID = this.collectedTerms.add(this.fromDocTermOrds.lookupOrd(ord));
                    if (termID < 0) {
                        termID = -termID - 1;
                    } else if (termID >= this.scoreSums.length) {
                        this.scoreSums = ArrayUtil.grow(this.scoreSums);
                        this.scoreCounts = ArrayUtil.grow(this.scoreCounts);
                    }
                    int n = termID;
                    this.scoreSums[n] = this.scoreSums[n] + this.scorer.score();
                    int n2 = termID;
                    this.scoreCounts[n2] = this.scoreCounts[n2] + 1;
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }

    static class SV
    extends TermsWithScoreCollector {
        BinaryDocValues fromDocTerms;

        SV(String field, ScoreMode scoreMode) {
            super(field, scoreMode);
        }

        @Override
        public void collect(int doc) throws IOException {
            int ord = this.collectedTerms.add(this.fromDocTerms.get(doc));
            if (ord < 0) {
                ord = -ord - 1;
            } else if (ord >= this.scoreSums.length) {
                int begin = this.scoreSums.length;
                this.scoreSums = ArrayUtil.grow(this.scoreSums);
                if (this.scoreMode == ScoreMode.Min) {
                    Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.POSITIVE_INFINITY);
                } else if (this.scoreMode == ScoreMode.Max) {
                    Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.NEGATIVE_INFINITY);
                }
            }
            float current = this.scorer.score();
            float existing = this.scoreSums[ord];
            if (Float.compare(existing, 0.0f) == 0) {
                this.scoreSums[ord] = current;
            } else {
                switch (this.scoreMode) {
                    case Total: {
                        this.scoreSums[ord] = this.scoreSums[ord] + current;
                        break;
                    }
                    case Min: {
                        if (!(current < existing)) break;
                        this.scoreSums[ord] = current;
                        break;
                    }
                    case Max: {
                        if (!(current > existing)) break;
                        this.scoreSums[ord] = current;
                    }
                }
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.fromDocTerms = DocValues.getBinary(context.reader(), this.field);
        }

        static class Avg
        extends SV {
            int[] scoreCounts = new int[0];

            Avg(String field) {
                super(field, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                int ord = this.collectedTerms.add(this.fromDocTerms.get(doc));
                if (ord < 0) {
                    ord = -ord - 1;
                } else if (ord >= this.scoreSums.length) {
                    this.scoreSums = ArrayUtil.grow(this.scoreSums);
                    this.scoreCounts = ArrayUtil.grow(this.scoreCounts);
                }
                float current = this.scorer.score();
                float existing = this.scoreSums[ord];
                if (Float.compare(existing, 0.0f) == 0) {
                    this.scoreSums[ord] = current;
                    this.scoreCounts[ord] = 1;
                } else {
                    this.scoreSums[ord] = this.scoreSums[ord] + current;
                    int n = ord;
                    this.scoreCounts[n] = this.scoreCounts[n] + 1;
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }
}

