/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class ToChildBlockJoinQuery
extends Query {
    static final String INVALID_QUERY_MESSAGE = "Parent query yields document which is not matched by parents filter, docID=";
    static final String ILLEGAL_ADVANCE_ON_PARENT = "Expect to be advanced on child docs only. got docID=";
    private final BitSetProducer parentsFilter;
    private final Query parentQuery;
    private final Query origParentQuery;

    public ToChildBlockJoinQuery(Query parentQuery, BitSetProducer parentsFilter) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
    }

    private ToChildBlockJoinQuery(Query origParentQuery, Query parentQuery, BitSetProducer parentsFilter) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher, needsScores), this.parentsFilter, needsScores);
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            return new ToChildBlockJoinQuery(this.parentQuery, parentRewrite, this.parentsFilter);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object _other) {
        if (_other instanceof ToChildBlockJoinQuery) {
            ToChildBlockJoinQuery other = (ToChildBlockJoinQuery)_other;
            return this.origParentQuery.equals(other.origParentQuery) && this.parentsFilter.equals(other.parentsFilter) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final BitSet parentBits;
        private final boolean doScores;
        private float parentScore;
        private int parentFreq = 1;
        private int childDoc = -1;
        private int parentDoc = 0;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, BitSet parentBits, boolean doScores) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.parentScorer, "BLOCK_JOIN"));
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.childDoc + 1 == this.parentDoc) {
                do {
                    this.parentDoc = this.parentScorer.nextDoc();
                    this.validateParentDoc();
                    if (this.parentDoc == 0) {
                        this.parentDoc = this.parentScorer.nextDoc();
                        this.validateParentDoc();
                    }
                    if (this.parentDoc == Integer.MAX_VALUE) {
                        this.childDoc = Integer.MAX_VALUE;
                        return this.childDoc;
                    }
                    this.childDoc = 1 + this.parentBits.prevSetBit(this.parentDoc - 1);
                } while (this.childDoc == this.parentDoc || this.childDoc >= this.parentDoc);
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                    this.parentFreq = this.parentScorer.freq();
                }
                return this.childDoc;
            }
            assert (this.childDoc < this.parentDoc) : "childDoc=" + this.childDoc + " parentDoc=" + this.parentDoc;
            ++this.childDoc;
            return this.childDoc;
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.INVALID_QUERY_MESSAGE + this.parentDoc);
            }
        }

        @Override
        public int docID() {
            return this.childDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public int freq() throws IOException {
            return this.parentFreq;
        }

        @Override
        public int advance(int childTarget) throws IOException {
            if (childTarget >= this.parentDoc) {
                int firstChild;
                block7: {
                    if (childTarget == Integer.MAX_VALUE) {
                        this.parentDoc = Integer.MAX_VALUE;
                        this.childDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.parentDoc = this.parentScorer.advance(childTarget + 1);
                    this.validateParentDoc();
                    if (this.parentDoc == Integer.MAX_VALUE) {
                        this.childDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    do {
                        if ((firstChild = this.parentBits.prevSetBit(this.parentDoc - 1) + 1) != this.parentDoc) break block7;
                        this.parentDoc = this.parentScorer.nextDoc();
                        this.validateParentDoc();
                    } while (this.parentDoc != Integer.MAX_VALUE);
                    this.childDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                childTarget = Math.max(childTarget, firstChild);
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                    this.parentFreq = this.parentScorer.freq();
                }
            }
            assert (childTarget < this.parentDoc);
            assert (!this.parentBits.get(childTarget));
            this.childDoc = childTarget;
            return this.childDoc;
        }

        @Override
        public long cost() {
            return this.parentScorer.cost();
        }

        int getParentDoc() {
            return this.parentDoc;
        }
    }

    private static class ToChildBlockJoinWeight
    extends Weight {
        private final Weight parentWeight;
        private final BitSetProducer parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, BitSetProducer parentsFilter, boolean doScores) {
            super(joinQuery);
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.parentWeight.getValueForNormalization();
        }

        @Override
        public void normalize(float norm, float boost) {
            this.parentWeight.normalize(norm, boost);
        }

        @Override
        public Scorer scorer(LeafReaderContext readerContext) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(readerContext);
            if (parentScorer == null) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(readerContext);
            if (parents == null) {
                return null;
            }
            return new ToChildBlockJoinScorer(this, parentScorer, parents, this.doScores);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            ToChildBlockJoinScorer scorer = (ToChildBlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.advance(doc) == doc) {
                int parentDoc = scorer.getParentDoc();
                return Explanation.match(scorer.score(), String.format(Locale.ROOT, "Score based on parent document %d", parentDoc + context.docBase), this.parentWeight.explain(context, parentDoc));
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }
    }
}

