/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.ScrollIdForNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;

public abstract class TransportSearchHelper {
    public static ShardSearchTransportRequest internalSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchRequest request, String[] filteringAliases, long nowInMillis) {
        return new ShardSearchTransportRequest(request, shardRouting, numberOfShards, filteringAliases, nowInMillis);
    }

    public static InternalScrollSearchRequest internalScrollSearchRequest(long id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    public static String buildScrollId(SearchType searchType, AtomicArray<? extends SearchPhaseResult> searchPhaseResults, @Nullable Map<String, String> attributes) throws IOException {
        if (searchType == SearchType.DFS_QUERY_THEN_FETCH || searchType == SearchType.QUERY_THEN_FETCH) {
            return TransportSearchHelper.buildScrollId("queryThenFetch", searchPhaseResults, attributes);
        }
        if (searchType == SearchType.QUERY_AND_FETCH || searchType == SearchType.DFS_QUERY_AND_FETCH) {
            return TransportSearchHelper.buildScrollId("queryAndFetch", searchPhaseResults, attributes);
        }
        if (searchType == SearchType.SCAN) {
            return TransportSearchHelper.buildScrollId("scan", searchPhaseResults, attributes);
        }
        throw new IllegalStateException("search_type [" + (Object)((Object)searchType) + "] not supported");
    }

    public static String buildScrollId(String type, AtomicArray<? extends SearchPhaseResult> searchPhaseResults, @Nullable Map<String, String> attributes) throws IOException {
        StringBuilder sb = new StringBuilder().append(type).append(';');
        sb.append(searchPhaseResults.asList().size()).append(';');
        for (AtomicArray.Entry<? extends SearchPhaseResult> entry : searchPhaseResults.asList()) {
            SearchPhaseResult searchPhaseResult = (SearchPhaseResult)entry.value;
            sb.append(searchPhaseResult.id()).append(':').append(searchPhaseResult.shardTarget().nodeId()).append(';');
        }
        if (attributes == null) {
            sb.append("0;");
        } else {
            sb.append(attributes.size()).append(";");
            for (Map.Entry entry : attributes.entrySet()) {
                sb.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append(';');
            }
        }
        BytesRef bytesRef = new BytesRef(sb);
        return Base64.encodeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length, 16);
    }

    public static ParsedScrollId parseScrollId(String scrollId) {
        ImmutableMap<String, String> attributes;
        int attributesSize;
        int contextSize;
        CharsRefBuilder spare = new CharsRefBuilder();
        try {
            byte[] decode = Base64.decode(scrollId, 16);
            spare.copyUTF8Bytes(decode, 0, decode.length);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decode scrollId", e);
        }
        String[] elements = Strings.splitStringToArray(spare.get(), ';');
        if (elements.length < 2) {
            throw new IllegalArgumentException("Malformed scrollId [" + scrollId + "]");
        }
        int index = 0;
        String type = elements[index++];
        if (elements.length < (contextSize = Integer.parseInt(elements[index++])) + 2) {
            throw new IllegalArgumentException("Malformed scrollId [" + scrollId + "]");
        }
        ScrollIdForNode[] context = new ScrollIdForNode[contextSize];
        for (int i = 0; i < contextSize; ++i) {
            String element;
            int sep;
            if ((sep = (element = elements[index++]).indexOf(58)) == -1) {
                throw new IllegalArgumentException("Malformed scrollId [" + scrollId + "]");
            }
            context[i] = new ScrollIdForNode(element.substring(sep + 1), Long.parseLong(element.substring(0, sep)));
        }
        if ((attributesSize = Integer.parseInt(elements[index++])) == 0) {
            attributes = ImmutableMap.of();
        } else {
            attributes = Maps.newHashMapWithExpectedSize(attributesSize);
            for (int i = 0; i < attributesSize; ++i) {
                String element = elements[index++];
                int sep = element.indexOf(58);
                attributes.put(element.substring(0, sep), element.substring(sep + 1));
            }
        }
        return new ParsedScrollId(scrollId, type, context, attributes);
    }

    private TransportSearchHelper() {
    }
}

