/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateFilter;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MetaDataCreateIndexService
extends AbstractComponent {
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private static final DefaultIndexTemplateFilter DEFAULT_INDEX_TEMPLATE_FILTER = new DefaultIndexTemplateFilter();
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final Version version;
    private final AliasValidator aliasValidator;
    private final IndexTemplateFilter indexTemplateFilter;
    private final Environment env;

    @Inject
    public MetaDataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, Version version, AliasValidator aliasValidator, Set<IndexTemplateFilter> indexTemplateFilters, Environment env) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.version = version;
        this.aliasValidator = aliasValidator;
        this.env = env;
        if (indexTemplateFilters.isEmpty()) {
            this.indexTemplateFilter = DEFAULT_INDEX_TEMPLATE_FILTER;
        } else {
            IndexTemplateFilter[] templateFilters = new IndexTemplateFilter[indexTemplateFilters.size() + 1];
            templateFilters[0] = DEFAULT_INDEX_TEMPLATE_FILTER;
            int i = 1;
            for (IndexTemplateFilter indexTemplateFilter : indexTemplateFilters) {
                templateFilters[i++] = indexTemplateFilter;
            }
            this.indexTemplateFilter = new IndexTemplateFilter.Compound(templateFilters);
        }
    }

    public void validateIndexName(String index, ClusterState state) {
        if (state.routingTable().hasIndex(index)) {
            throw new IndexAlreadyExistsException(new Index(index));
        }
        if (state.metaData().hasIndex(index)) {
            throw new IndexAlreadyExistsException(new Index(index));
        }
        if (!Strings.validFileName(index)) {
            throw new InvalidIndexNameException(new Index(index), index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw new InvalidIndexNameException(new Index(index), index, "must not contain '#'");
        }
        if (index.charAt(0) == '_') {
            throw new InvalidIndexNameException(new Index(index), index, "must not start with '_'");
        }
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(new Index(index), index, "must be lowercase");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw new InvalidIndexNameException(new Index(index), index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (state.metaData().hasAlias(index)) {
            throw new InvalidIndexNameException(new Index(index), index, "already exists as alias");
        }
        if (index.equals(".") || index.equals("..")) {
            throw new InvalidIndexNameException(new Index(index), index, "must not be '.' or '..'");
        }
    }

    public void createIndex(final CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.settingsBuilder();
        updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        request.settings(updatedSettingsBuilder.build());
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState;
                block41: {
                    boolean indexCreated = false;
                    String removalReason = null;
                    try {
                        IndexMetaData indexMetaData;
                        void var10_16;
                        MetaDataCreateIndexService.this.validate(request, currentState);
                        for (Alias alias : request.aliases()) {
                            MetaDataCreateIndexService.this.aliasValidator.validateAlias(alias, request.index(), currentState.metaData());
                        }
                        List templates = MetaDataCreateIndexService.this.findTemplates(request, currentState, MetaDataCreateIndexService.this.indexTemplateFilter);
                        HashMap<String, Object> customs = Maps.newHashMap();
                        HashMap<String, Map> mappings = Maps.newHashMap();
                        HashMap<String, AliasMetaData> templatesAliases = Maps.newHashMap();
                        ArrayList<String> templateNames = new ArrayList<String>();
                        for (Map.Entry<String, String> entry : request.mappings().entrySet()) {
                            mappings.put(entry.getKey(), MetaDataCreateIndexService.this.parseMapping(entry.getValue()));
                        }
                        for (Map.Entry<String, Object> entry : request.customs().entrySet()) {
                            customs.put(entry.getKey(), entry.getValue());
                        }
                        for (IndexTemplateMetaData indexTemplateMetaData : templates) {
                            templateNames.add(indexTemplateMetaData.getName());
                            for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetaData.mappings()) {
                                if (mappings.containsKey(objectObjectCursor.key)) {
                                    XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MetaDataCreateIndexService.this.parseMapping(((CompressedXContent)objectObjectCursor.value).string()));
                                    continue;
                                }
                                mappings.put((String)objectObjectCursor.key, MetaDataCreateIndexService.this.parseMapping(((CompressedXContent)objectObjectCursor.value).string()));
                            }
                            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexTemplateMetaData.customs()) {
                                String type = (String)objectObjectCursor.key;
                                IndexMetaData.Custom custom = (IndexMetaData.Custom)objectObjectCursor.value;
                                IndexMetaData.Custom existing = (IndexMetaData.Custom)customs.get(type);
                                if (existing == null) {
                                    customs.put(type, custom);
                                    continue;
                                }
                                IndexMetaData.Custom merged = existing.mergeWith(custom);
                                customs.put(type, merged);
                            }
                            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexTemplateMetaData.aliases()) {
                                AliasMetaData aliasMetaData = (AliasMetaData)objectObjectCursor.value;
                                if (request.aliases().contains(new Alias(aliasMetaData.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                                if (aliasMetaData.alias().contains("{index}")) {
                                    String templatedAlias = aliasMetaData.alias().replace("{index}", request.index());
                                    aliasMetaData = AliasMetaData.newAliasMetaData(aliasMetaData, templatedAlias);
                                }
                                MetaDataCreateIndexService.this.aliasValidator.validateAliasMetaData(aliasMetaData, request.index(), currentState.metaData());
                                templatesAliases.put(aliasMetaData.alias(), aliasMetaData);
                            }
                        }
                        Settings.Builder indexSettingsBuilder = Settings.settingsBuilder();
                        int n = templates.size() - 1;
                        while (var10_16 >= 0) {
                            indexSettingsBuilder.put(((IndexTemplateMetaData)templates.get((int)var10_16)).settings());
                            --var10_16;
                        }
                        indexSettingsBuilder.put(request.settings());
                        if (request.index().equals(".scripts")) {
                            indexSettingsBuilder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)1));
                        } else if (indexSettingsBuilder.get("index.number_of_shards") == null) {
                            indexSettingsBuilder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)5));
                        }
                        if (request.index().equals(".scripts")) {
                            indexSettingsBuilder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)0));
                            indexSettingsBuilder.put("index.auto_expand_replicas", "0-all");
                        } else if (indexSettingsBuilder.get("index.number_of_replicas") == null) {
                            indexSettingsBuilder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)1));
                        }
                        if (MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas") != null && indexSettingsBuilder.get("index.auto_expand_replicas") == null) {
                            indexSettingsBuilder.put("index.auto_expand_replicas", MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas"));
                        }
                        if (indexSettingsBuilder.get("index.version.created") == null) {
                            DiscoveryNodes discoveryNodes = currentState.nodes();
                            Version createdVersion = Version.smallest(MetaDataCreateIndexService.this.version, discoveryNodes.smallestNonClientNodeVersion());
                            indexSettingsBuilder.put("index.version.created", createdVersion);
                        }
                        if (indexSettingsBuilder.get("index.creation_date") == null) {
                            indexSettingsBuilder.put("index.creation_date", new DateTime(DateTimeZone.UTC).getMillis());
                        }
                        indexSettingsBuilder.put("index.uuid", Strings.randomBase64UUID());
                        Settings settings = indexSettingsBuilder.build();
                        MetaDataCreateIndexService.this.indicesService.createIndex(request.index(), settings, MetaDataCreateIndexService.this.clusterService.localNode().id());
                        indexCreated = true;
                        IndexService indexService = MetaDataCreateIndexService.this.indicesService.indexServiceSafe(request.index());
                        MapperService mapperService = indexService.mapperService();
                        if (mappings.containsKey("_default_")) {
                            try {
                                mapperService.merge("_default_", new CompressedXContent(XContentFactory.jsonBuilder().map((Map)mappings.get("_default_")).string()), false, request.updateAllTypes());
                            }
                            catch (Exception e) {
                                removalReason = "failed on parsing default mapping on index creation";
                                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, "_default_", e.getMessage());
                            }
                        }
                        for (Map.Entry entry : mappings.entrySet()) {
                            if (((String)entry.getKey()).equals("_default_")) continue;
                            try {
                                mapperService.merge((String)entry.getKey(), new CompressedXContent(XContentFactory.jsonBuilder().map((Map)entry.getValue()).string()), true, request.updateAllTypes());
                            }
                            catch (Exception e) {
                                removalReason = "failed on parsing mappings on index creation";
                                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
                            }
                        }
                        IndexQueryParserService indexQueryParserService = indexService.queryParserService();
                        for (Alias alias : request.aliases()) {
                            if (!Strings.hasLength(alias.filter())) continue;
                            MetaDataCreateIndexService.this.aliasValidator.validateAliasFilter(alias.name(), alias.filter(), indexQueryParserService);
                        }
                        for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                            if (aliasMetaData.filter() == null) continue;
                            MetaDataCreateIndexService.this.aliasValidator.validateAliasFilter(aliasMetaData.alias(), aliasMetaData.filter().uncompressed(), indexQueryParserService);
                        }
                        HashMap<String, MappingMetaData> mappingsMetaData = Maps.newHashMap();
                        for (DocumentMapper mapper : mapperService.docMappers(true)) {
                            MappingMetaData mappingMetaData = new MappingMetaData(mapper);
                            mappingsMetaData.put(mapper.type(), mappingMetaData);
                        }
                        IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(request.index()).settings(settings);
                        for (MappingMetaData mappingMetaData : mappingsMetaData.values()) {
                            indexMetaDataBuilder.putMapping(mappingMetaData);
                        }
                        for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                            indexMetaDataBuilder.putAlias(aliasMetaData);
                        }
                        for (Alias alias : request.aliases()) {
                            AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).build();
                            indexMetaDataBuilder.putAlias(aliasMetaData);
                        }
                        for (Map.Entry entry : customs.entrySet()) {
                            indexMetaDataBuilder.putCustom((String)entry.getKey(), (IndexMetaData.Custom)entry.getValue());
                        }
                        indexMetaDataBuilder.state(request.state());
                        try {
                            indexMetaData = indexMetaDataBuilder.build();
                        }
                        catch (Exception exception) {
                            removalReason = "failed to build index metadata";
                            throw exception;
                        }
                        indexService.indicesLifecycle().beforeIndexAddedToCluster(new Index(request.index()), indexMetaData.getSettings());
                        MetaData metaData = MetaData.builder(currentState.metaData()).put(indexMetaData, false).build();
                        String maybeShadowIndicator = IndexMetaData.isIndexUsingShadowReplicas(indexMetaData.getSettings()) ? "s" : "";
                        MetaDataCreateIndexService.this.logger.info("[{}] creating index, cause [{}], templates {}, shards [{}]/[{}{}], mappings {}", request.index(), request.cause(), templateNames, indexMetaData.getNumberOfShards(), indexMetaData.getNumberOfReplicas(), maybeShadowIndicator, mappings.keySet());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                        if (!request.blocks().isEmpty()) {
                            for (ClusterBlock block : request.blocks()) {
                                blocks.addIndexBlock(request.index(), block);
                            }
                        }
                        blocks.updateBlocks(indexMetaData);
                        ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(metaData).build();
                        if (request.state() == IndexMetaData.State.OPEN) {
                            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metaData().index(request.index()));
                            RoutingAllocation.Result routingResult = MetaDataCreateIndexService.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "index [" + request.index() + "] created");
                            updatedState = ClusterState.builder(updatedState).routingResult(routingResult).build();
                        }
                        removalReason = "cleaning up after validating index on master";
                        clusterState = updatedState;
                        if (!indexCreated) break block41;
                    }
                    catch (Throwable throwable) {
                        if (indexCreated) {
                            MetaDataCreateIndexService.this.indicesService.removeIndex(request.index(), removalReason != null ? removalReason : "failed to create index");
                        }
                        throw throwable;
                    }
                    MetaDataCreateIndexService.this.indicesService.removeIndex(request.index(), removalReason != null ? removalReason : "failed to create index");
                }
                return clusterState;
            }
        });
    }

    private Map<String, Object> parseMapping(String mappingSource) throws Exception {
        try (XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    private void addMappings(Map<String, Map<String, Object>> mappings, Path mappingsDir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(mappingsDir);){
            for (Path mappingFile : stream) {
                String fileName = mappingFile.getFileName().toString();
                if (FileSystemUtils.isHidden(mappingFile)) continue;
                int lastDotIndex = fileName.lastIndexOf(46);
                String mappingType = lastDotIndex != -1 ? mappingFile.getFileName().toString().substring(0, lastDotIndex) : mappingFile.getFileName().toString();
                try {
                    BufferedReader reader = Files.newBufferedReader(mappingFile, Charsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        String mappingSource = Streams.copyToString(reader);
                        if (mappings.containsKey(mappingType)) {
                            XContentHelper.mergeDefaults(mappings.get(mappingType), this.parseMapping(mappingSource));
                            continue;
                        }
                        mappings.put(mappingType, this.parseMapping(mappingSource));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Exception e) {
                    this.logger.warn("failed to read / parse mapping [" + mappingType + "] from location [" + mappingFile + "], ignoring...", e, new Object[0]);
                }
            }
        }
    }

    private List<IndexTemplateMetaData> findTemplates(CreateIndexClusterStateUpdateRequest request, ClusterState state, IndexTemplateFilter indexTemplateFilter) throws IOException {
        ArrayList<IndexTemplateMetaData> templates = new ArrayList<IndexTemplateMetaData>();
        for (ObjectCursor<IndexTemplateMetaData> objectCursor : state.metaData().templates().values()) {
            IndexTemplateMetaData template = (IndexTemplateMetaData)objectCursor.value;
            if (!indexTemplateFilter.apply(request, template)) continue;
            templates.add(template);
        }
        CollectionUtil.timSort(templates, new Comparator<IndexTemplateMetaData>(){

            @Override
            public int compare(IndexTemplateMetaData o1, IndexTemplateMetaData o2) {
                return o2.order() - o1.order();
            }
        });
        return templates;
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        this.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings());
    }

    public void validateIndexSettings(String indexName, Settings settings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(new Index(indexName), (Throwable)validationException);
        }
    }

    List<String> getIndexSettingsValidationErrors(Settings settings) {
        Path resolvedPath;
        String customPath = settings.get("index.data_path", null);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (customPath != null && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (customPath != null && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + this.env.sharedDataFile() + "]");
        }
        Integer number_of_primaries = settings.getAsInt("index.number_of_shards", null);
        Integer number_of_replicas = settings.getAsInt("index.number_of_replicas", null);
        if (number_of_primaries != null && number_of_primaries <= 0) {
            validationErrors.add("index must have 1 or more primary shards");
        }
        if (number_of_replicas != null && number_of_replicas < 0) {
            validationErrors.add("index must have 0 or more replica shards");
        }
        return validationErrors;
    }

    private static class DefaultIndexTemplateFilter
    implements IndexTemplateFilter {
        private DefaultIndexTemplateFilter() {
        }

        @Override
        public boolean apply(CreateIndexClusterStateUpdateRequest request, IndexTemplateMetaData template) {
            return Regex.simpleMatch(template.template(), request.index());
        }
    }
}

