/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.CustomBoostFactorScorer;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    Query subQuery;
    final ScoreFunction function;
    float maxBoost = Float.MAX_VALUE;
    CombineFunction combineFunction;
    private Float minScore = null;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function, Float minScore) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = function == null ? CombineFunction.MULT : function.getDefaultScoreCombiner();
        this.minScore = minScore;
    }

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = function.getDefaultScoreCombiner();
    }

    public void setCombineFunction(CombineFunction combineFunction) {
        this.combineFunction = combineFunction;
    }

    public void setMaxBoost(float maxBoost) {
        this.maxBoost = maxBoost;
    }

    public float getMaxBoost() {
        return this.maxBoost;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FunctionScoreQuery bq = (FunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!needsScores) {
            return this.subQuery.createWeight(searcher, needsScores);
        }
        boolean subQueryNeedsScores = this.combineFunction != CombineFunction.REPLACE || this.function == null || this.function.needsScores();
        Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryNeedsScores);
        return new CustomBoostFactorWeight(this, subQueryWeight, subQueryNeedsScores);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(",function=").append(this.function).append(')');
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)o;
        return Objects.equals(this.subQuery, other.subQuery) && Objects.equals(this.function, other.function) && Objects.equals((Object)this.combineFunction, (Object)other.combineFunction) && Objects.equals(this.minScore, other.minScore) && this.maxBoost == other.maxBoost;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.subQuery.hashCode(), this.function, this.combineFunction, this.minScore, Float.valueOf(this.maxBoost)});
    }

    static class FunctionFactorScorer
    extends CustomBoostFactorScorer {
        private final LeafScoreFunction function;
        private final boolean needsScores;

        private FunctionFactorScorer(CustomBoostFactorWeight w, Scorer scorer, LeafScoreFunction function, float maxBoost, CombineFunction scoreCombiner, Float minScore, boolean needsScores) throws IOException {
            super(w, scorer, maxBoost, scoreCombiner, minScore);
            this.function = function;
            this.needsScores = needsScores;
        }

        @Override
        public float innerScore() throws IOException {
            float score;
            float f = score = this.needsScores ? this.scorer.score() : 0.0f;
            if (this.function == null) {
                return score;
            }
            return this.scoreCombiner.combine(score, this.function.score(this.scorer.docID(), score), this.maxBoost);
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;
        final boolean needsScores;

        public CustomBoostFactorWeight(Query parent, Weight subQueryWeight, boolean needsScores) throws IOException {
            super(parent);
            this.subQueryWeight = subQueryWeight;
            this.needsScores = needsScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.subQueryWeight.extractTerms(terms);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.subQueryWeight.getValueForNormalization();
        }

        @Override
        public void normalize(float norm, float boost) {
            this.subQueryWeight.normalize(norm, boost);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context);
            if (subQueryScorer == null) {
                return null;
            }
            LeafScoreFunction leafFunction = null;
            if (FunctionScoreQuery.this.function != null) {
                leafFunction = FunctionScoreQuery.this.function.getLeafScoreFunction(context);
            }
            return new FunctionFactorScorer(this, subQueryScorer, leafFunction, FunctionScoreQuery.this.maxBoost, FunctionScoreQuery.this.combineFunction, FunctionScoreQuery.this.minScore, this.needsScores);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            if (FunctionScoreQuery.this.function != null) {
                Explanation functionExplanation = FunctionScoreQuery.this.function.getLeafScoreFunction(context).explainScore(doc, subQueryExpl);
                return FunctionScoreQuery.this.combineFunction.explain(subQueryExpl, functionExplanation, FunctionScoreQuery.this.maxBoost);
            }
            return subQueryExpl;
        }
    }
}

