/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import com.google.common.net.InetAddresses;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.elasticsearch.common.SuppressForbidden;

public final class NetworkAddress {
    private NetworkAddress() {
    }

    public static String format(InetAddress address) {
        return NetworkAddress.format(address, -1, true);
    }

    public static String format(InetSocketAddress address) {
        return NetworkAddress.format(address.getAddress(), address.getPort(), true);
    }

    public static String formatAddress(InetAddress address) {
        return NetworkAddress.format(address, -1, false);
    }

    public static String formatAddress(InetSocketAddress address) {
        return NetworkAddress.format(address.getAddress(), address.getPort(), false);
    }

    @SuppressForbidden(reason="we call toString to avoid a DNS lookup")
    static String format(InetAddress address, int port, boolean includeHost) {
        String toString;
        int separator;
        Objects.requireNonNull(address);
        StringBuilder builder = new StringBuilder();
        if (includeHost && (separator = (toString = address.toString()).indexOf(47)) > 0) {
            builder.append(toString, 0, separator + 1);
        }
        if (port != -1 && address instanceof Inet6Address) {
            builder.append(InetAddresses.toUriString(address));
        } else {
            builder.append(InetAddresses.toAddrString(address));
        }
        if (port != -1) {
            builder.append(':');
            builder.append(port);
        }
        return builder.toString();
    }
}

