/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class TimeValue
implements Streamable {
    public static final long NSEC_PER_MSEC = 1000000L;
    private long duration;
    private TimeUnit timeUnit;
    private final PeriodFormatter defaultFormatter = PeriodFormat.getDefault().withParseType(PeriodType.standard());
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;

    public static TimeValue timeValueNanos(long nanos) {
        return new TimeValue(nanos, TimeUnit.NANOSECONDS);
    }

    public static TimeValue timeValueMillis(long millis) {
        return new TimeValue(millis, TimeUnit.MILLISECONDS);
    }

    public static TimeValue timeValueSeconds(long seconds) {
        return new TimeValue(seconds, TimeUnit.SECONDS);
    }

    public static TimeValue timeValueMinutes(long minutes) {
        return new TimeValue(minutes, TimeUnit.MINUTES);
    }

    public static TimeValue timeValueHours(long hours) {
        return new TimeValue(hours, TimeUnit.HOURS);
    }

    private TimeValue() {
    }

    public TimeValue(long millis) {
        this(millis, TimeUnit.MILLISECONDS);
    }

    public TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long nanos() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long getNanos() {
        return this.nanos();
    }

    public long micros() {
        return this.timeUnit.toMicros(this.duration);
    }

    public long getMicros() {
        return this.micros();
    }

    public long millis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public long getMillis() {
        return this.millis();
    }

    public long seconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public long getSeconds() {
        return this.seconds();
    }

    public long minutes() {
        return this.timeUnit.toMinutes(this.duration);
    }

    public long getMinutes() {
        return this.minutes();
    }

    public long hours() {
        return this.timeUnit.toHours(this.duration);
    }

    public long getHours() {
        return this.hours();
    }

    public long days() {
        return this.timeUnit.toDays(this.duration);
    }

    public long getDays() {
        return this.days();
    }

    public double microsFrac() {
        return (double)this.nanos() / 1000.0;
    }

    public double getMicrosFrac() {
        return this.microsFrac();
    }

    public double millisFrac() {
        return (double)this.nanos() / 1000000.0;
    }

    public double getMillisFrac() {
        return this.millisFrac();
    }

    public double secondsFrac() {
        return (double)this.nanos() / 1.0E9;
    }

    public double getSecondsFrac() {
        return this.secondsFrac();
    }

    public double minutesFrac() {
        return (double)this.nanos() / 6.0E10;
    }

    public double getMinutesFrac() {
        return this.minutesFrac();
    }

    public double hoursFrac() {
        return (double)this.nanos() / 3.6E12;
    }

    public double getHoursFrac() {
        return this.hoursFrac();
    }

    public double daysFrac() {
        return (double)this.nanos() / 8.64E13;
    }

    public double getDaysFrac() {
        return this.daysFrac();
    }

    public String format() {
        Period period = new Period(this.millis());
        return this.defaultFormatter.print(period);
    }

    public String format(PeriodType type) {
        Period period = new Period(this.millis());
        return PeriodFormat.getDefault().withParseType(type).print(period);
    }

    public String toString() {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        long nanos = this.nanos();
        if (nanos == 0L) {
            return "0s";
        }
        double value = nanos;
        String suffix = "nanos";
        if (nanos >= 86400000000000L) {
            value = this.daysFrac();
            suffix = "d";
        } else if (nanos >= 3600000000000L) {
            value = this.hoursFrac();
            suffix = "h";
        } else if (nanos >= 60000000000L) {
            value = this.minutesFrac();
            suffix = "m";
        } else if (nanos >= 1000000000L) {
            value = this.secondsFrac();
            suffix = "s";
        } else if (nanos >= 1000000L) {
            value = this.millisFrac();
            suffix = "ms";
        } else if (nanos >= 1000L) {
            value = this.microsFrac();
            suffix = "micros";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static TimeValue parseTimeValue(String sValue, TimeValue defaultValue, String settingName) {
        settingName = Objects.requireNonNull(settingName);
        assert (!settingName.startsWith("index.") || MetaDataIndexUpgradeService.INDEX_TIME_SETTINGS.contains(settingName));
        if (sValue == null) {
            return defaultValue;
        }
        try {
            long millis;
            String lowerSValue = sValue.toLowerCase(Locale.ROOT).trim();
            if (lowerSValue.endsWith("ms")) {
                millis = (long)Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2));
            } else if (lowerSValue.endsWith("s")) {
                millis = (long)Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1000L;
            } else if (lowerSValue.endsWith("m")) {
                millis = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 60.0 * 1000.0);
            } else if (lowerSValue.endsWith("h")) {
                millis = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 60.0 * 60.0 * 1000.0);
            } else if (lowerSValue.endsWith("d")) {
                millis = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 24.0 * 60.0 * 60.0 * 1000.0);
            } else if (lowerSValue.endsWith("w")) {
                millis = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 7.0 * 24.0 * 60.0 * 60.0 * 1000.0);
            } else if (lowerSValue.equals("-1")) {
                millis = -1L;
            } else if (lowerSValue.equals("0")) {
                millis = 0L;
            } else {
                if (Settings.getSettingsRequireUnits()) {
                    throw new ElasticsearchParseException("Failed to parse setting [{}] with value [{}] as a time value: unit is missing or unrecognized", settingName, sValue);
                }
                millis = Long.parseLong(sValue);
            }
            return new TimeValue(millis, TimeUnit.MILLISECONDS);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchParseException("Failed to parse [{}]", (Throwable)e, sValue);
        }
    }

    public static TimeValue readTimeValue(StreamInput in) throws IOException {
        TimeValue timeValue = new TimeValue();
        timeValue.readFrom(in);
        return timeValue;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.duration = in.readLong();
        this.timeUnit = TimeUnit.NANOSECONDS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.nanos());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeValue timeValue = (TimeValue)o;
        return this.timeUnit.toNanos(this.duration) == timeValue.timeUnit.toNanos(timeValue.duration);
    }

    public int hashCode() {
        long normalized = this.timeUnit.toNanos(this.duration);
        return (int)(normalized ^ normalized >>> 32);
    }

    public static long nsecToMSec(long ns) {
        return ns / 1000000L;
    }
}

