/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.filter.FilteringGeneratorDelegate;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentString;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;
import org.elasticsearch.common.xcontent.support.filtering.FilterPathBasedFilter;

public class JsonXContentGenerator
implements XContentGenerator {
    protected final JsonGenerator generator;
    private final GeneratorBase base;
    private final FilteringGeneratorDelegate filter;
    private final OutputStream os;
    private boolean writeLineFeedAtEnd;
    private static final SerializedString LF = new SerializedString("\n");
    private static final DefaultPrettyPrinter.Indenter INDENTER = new DefaultIndenter("  ", LF.getValue());
    private boolean prettyPrint = false;

    public JsonXContentGenerator(JsonGenerator jsonGenerator, OutputStream os, String ... filters) {
        this.base = jsonGenerator instanceof GeneratorBase ? (GeneratorBase)jsonGenerator : null;
        if (CollectionUtils.isEmpty(filters)) {
            this.generator = jsonGenerator;
            this.filter = null;
        } else {
            this.filter = new FilteringGeneratorDelegate(jsonGenerator, new FilterPathBasedFilter(filters), true, true);
            this.generator = this.filter;
        }
        this.os = os;
    }

    @Override
    public XContentType contentType() {
        return XContentType.JSON;
    }

    @Override
    public final void usePrettyPrint() {
        this.generator.setPrettyPrinter(new DefaultPrettyPrinter().withObjectIndenter(INDENTER));
        this.prettyPrint = true;
    }

    @Override
    public void usePrintLineFeedAtEnd() {
        this.writeLineFeedAtEnd = true;
    }

    @Override
    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    protected boolean isFiltered() {
        return this.filter != null;
    }

    protected boolean inRoot() {
        if (this.isFiltered()) {
            JsonStreamContext context = this.filter.getFilterContext();
            return context != null && context.inRoot() && context.getCurrentName() == null;
        }
        return false;
    }

    @Override
    public void writeStartObject() throws IOException {
        if (this.isFiltered() && this.inRoot()) {
            this.filter.getDelegate().writeStartObject();
            return;
        }
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() throws IOException {
        if (this.isFiltered() && this.inRoot()) {
            this.filter.getDelegate().writeEndObject();
            return;
        }
        this.generator.writeEndObject();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeFieldName(XContentString name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeString(String text) throws IOException {
        this.generator.writeString(text);
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this.generator.writeString(text, offset, len);
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.generator.writeUTF8String(text, offset, length);
    }

    @Override
    public void writeBinary(byte[] data, int offset, int len) throws IOException {
        this.generator.writeBinary(data, offset, len);
    }

    @Override
    public void writeBinary(byte[] data) throws IOException {
        this.generator.writeBinary(data);
    }

    @Override
    public void writeNumber(int v) throws IOException {
        this.generator.writeNumber(v);
    }

    @Override
    public void writeNumber(long v) throws IOException {
        this.generator.writeNumber(v);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this.generator.writeNumber(d);
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this.generator.writeNumber(f);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this.generator.writeBoolean(state);
    }

    @Override
    public void writeNull() throws IOException {
        this.generator.writeNull();
    }

    @Override
    public void writeStringField(String fieldName, String value) throws IOException {
        this.generator.writeStringField(fieldName, value);
    }

    @Override
    public void writeStringField(XContentString fieldName, String value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeString(value);
    }

    @Override
    public void writeBooleanField(String fieldName, boolean value) throws IOException {
        this.generator.writeBooleanField(fieldName, value);
    }

    @Override
    public void writeBooleanField(XContentString fieldName, boolean value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeBoolean(value);
    }

    @Override
    public void writeNullField(String fieldName) throws IOException {
        this.generator.writeNullField(fieldName);
    }

    @Override
    public void writeNullField(XContentString fieldName) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNull();
    }

    @Override
    public void writeNumberField(String fieldName, int value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, int value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String fieldName, long value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, long value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String fieldName, double value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, double value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String fieldName, float value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, float value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeBinaryField(String fieldName, byte[] data) throws IOException {
        this.generator.writeBinaryField(fieldName, data);
    }

    @Override
    public void writeBinaryField(XContentString fieldName, byte[] value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeBinary(value);
    }

    @Override
    public void writeArrayFieldStart(String fieldName) throws IOException {
        this.generator.writeArrayFieldStart(fieldName);
    }

    @Override
    public void writeArrayFieldStart(XContentString fieldName) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeStartArray();
    }

    @Override
    public void writeObjectFieldStart(String fieldName) throws IOException {
        this.generator.writeObjectFieldStart(fieldName);
    }

    @Override
    public void writeObjectFieldStart(XContentString fieldName) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeStartObject();
    }

    private void writeStartRaw(String fieldName) throws IOException {
        this.writeFieldName(fieldName);
        this.generator.writeRaw(':');
    }

    public void writeEndRaw() {
        assert (this.base != null) : "JsonGenerator should be of instance GeneratorBase but was: " + this.generator.getClass();
        if (this.base != null) {
            this.base.getOutputContext().writeValue();
        }
    }

    @Override
    public void writeRawField(String fieldName, InputStream content) throws IOException {
        XContentType contentType;
        if (!content.markSupported()) {
            content = new BufferedInputStream(content);
        }
        if ((contentType = XContentFactory.xContentType(content)) == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        if (!this.mayWriteRawData(contentType)) {
            try (XContentParser parser = XContentFactory.xContent(contentType).createParser(content);){
                parser.nextToken();
                this.writeFieldName(fieldName);
                this.copyCurrentStructure(parser);
            }
        } else {
            this.writeStartRaw(fieldName);
            this.flush();
            Streams.copy(content, this.os);
            this.writeEndRaw();
        }
    }

    @Override
    public final void writeRawField(String fieldName, BytesReference content) throws IOException {
        XContentType contentType = XContentFactory.xContentType(content);
        if (contentType == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        if (!this.mayWriteRawData(contentType)) {
            this.writeFieldName(fieldName);
            this.copyRawValue(content, contentType.xContent());
        } else {
            this.writeStartRaw(fieldName);
            this.flush();
            content.writeTo(this.os);
            this.writeEndRaw();
        }
    }

    @Override
    public final void writeRawValue(BytesReference content) throws IOException {
        XContentType contentType = XContentFactory.xContentType(content);
        if (contentType == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        if (!this.mayWriteRawData(contentType)) {
            this.copyRawValue(content, contentType.xContent());
        } else {
            this.flush();
            content.writeTo(this.os);
            this.writeEndRaw();
        }
    }

    private boolean mayWriteRawData(XContentType contentType) {
        return this.supportsRawWrites() && !this.isFiltered() && contentType == this.contentType() && !this.prettyPrint;
    }

    protected boolean supportsRawWrites() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyRawValue(BytesReference content, XContent xContent) throws IOException {
        try (Releasable parser = null;){
            parser = content.hasArray() ? xContent.createParser(content.array(), content.arrayOffset(), content.length()) : xContent.createParser(content.streamInput());
            this.copyCurrentStructure((XContentParser)parser);
        }
    }

    @Override
    public void copyCurrentStructure(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser instanceof JsonXContentParser) {
            this.generator.copyCurrentStructure(((JsonXContentParser)parser).parser);
        } else {
            XContentHelper.copyCurrentStructure(this, parser);
        }
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.generator.isClosed()) {
            return;
        }
        if (this.writeLineFeedAtEnd) {
            this.flush();
            this.generator.writeRaw(LF);
        }
        this.generator.close();
    }
}

