/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.elect;

import com.carrotsearch.hppc.ObjectContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;

public class ElectMasterService
extends AbstractComponent {
    public static final String DISCOVERY_ZEN_MINIMUM_MASTER_NODES = "discovery.zen.minimum_master_nodes";
    public static final Validator DISCOVERY_ZEN_MINIMUM_MASTER_NODES_VALIDATOR = new Validator(){

        @Override
        public String validate(String setting, String value, ClusterState clusterState) {
            int intValue;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value + "] as an integer";
            }
            int masterNodes = clusterState.nodes().masterNodes().size();
            if (intValue > masterNodes) {
                return "cannot set discovery.zen.minimum_master_nodes to more than the current master nodes count [" + masterNodes + "]";
            }
            return null;
        }
    };
    private final Version minMasterVersion;
    private final NodeComparator nodeComparator = new NodeComparator();
    private volatile int minimumMasterNodes;

    @Inject
    public ElectMasterService(Settings settings, Version version) {
        super(settings);
        this.minMasterVersion = version.minimumCompatibilityVersion();
        this.minimumMasterNodes = settings.getAsInt(DISCOVERY_ZEN_MINIMUM_MASTER_NODES, (Integer)-1);
        this.logger.debug("using minimum_master_nodes [{}]", this.minimumMasterNodes);
    }

    public void minimumMasterNodes(int minimumMasterNodes) {
        this.minimumMasterNodes = minimumMasterNodes;
    }

    public int minimumMasterNodes() {
        return this.minimumMasterNodes;
    }

    public boolean hasEnoughMasterNodes(Iterable<DiscoveryNode> nodes) {
        if (this.minimumMasterNodes < 1) {
            return true;
        }
        int count = 0;
        for (DiscoveryNode node : nodes) {
            if (!node.masterNode()) continue;
            ++count;
        }
        return count >= this.minimumMasterNodes;
    }

    public List<DiscoveryNode> sortByMasterLikelihood(Iterable<DiscoveryNode> nodes) {
        ArrayList<DiscoveryNode> sortedNodes = CollectionUtils.iterableAsArrayList(nodes);
        CollectionUtil.introSort(sortedNodes, this.nodeComparator);
        return sortedNodes;
    }

    public DiscoveryNode[] nextPossibleMasters(ObjectContainer<DiscoveryNode> nodes, int numberOfPossibleMasters) {
        List<DiscoveryNode> sortedNodes = this.sortedMasterNodes(Arrays.asList(nodes.toArray(DiscoveryNode.class)));
        if (sortedNodes == null) {
            return new DiscoveryNode[0];
        }
        ArrayList<DiscoveryNode> nextPossibleMasters = new ArrayList<DiscoveryNode>(numberOfPossibleMasters);
        int counter = 0;
        for (DiscoveryNode nextPossibleMaster : sortedNodes) {
            if (++counter >= numberOfPossibleMasters) break;
            nextPossibleMasters.add(nextPossibleMaster);
        }
        return nextPossibleMasters.toArray(new DiscoveryNode[nextPossibleMasters.size()]);
    }

    public DiscoveryNode electMaster(Iterable<DiscoveryNode> nodes) {
        List<DiscoveryNode> sortedNodes = this.sortedMasterNodes(nodes);
        if (sortedNodes == null || sortedNodes.isEmpty()) {
            return null;
        }
        DiscoveryNode masterNode = sortedNodes.get(0);
        if (masterNode.getVersion().before(this.minMasterVersion)) {
            this.logger.warn("ignoring master [{}], because the version [{}] is lower than the minimum compatible version [{}]", masterNode, masterNode.getVersion(), this.minMasterVersion);
            return null;
        }
        return masterNode;
    }

    private List<DiscoveryNode> sortedMasterNodes(Iterable<DiscoveryNode> nodes) {
        ArrayList<DiscoveryNode> possibleNodes = CollectionUtils.iterableAsArrayList(nodes);
        if (possibleNodes.isEmpty()) {
            return null;
        }
        Iterator it = possibleNodes.iterator();
        while (it.hasNext()) {
            DiscoveryNode node = (DiscoveryNode)it.next();
            if (node.masterNode()) continue;
            it.remove();
        }
        CollectionUtil.introSort(possibleNodes, this.nodeComparator);
        return possibleNodes;
    }

    private static class NodeComparator
    implements Comparator<DiscoveryNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(DiscoveryNode o1, DiscoveryNode o2) {
            if (o1.masterNode() && !o2.masterNode()) {
                return -1;
            }
            if (!o1.masterNode() && o2.masterNode()) {
                return 1;
            }
            return o1.id().compareTo(o2.id());
        }
    }
}

