/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.util.regex.Pattern;
import org.elasticsearch.http.netty.NettyHttpChannel;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.http.netty.NettyHttpServerTransport;
import org.elasticsearch.http.netty.pipelining.OrderedUpstreamMessageEvent;
import org.elasticsearch.rest.support.RestUtils;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    private final NettyHttpServerTransport serverTransport;
    private final Pattern corsPattern;
    private final boolean httpPipeliningEnabled;
    private final boolean detailedErrorsEnabled;

    public HttpRequestHandler(NettyHttpServerTransport serverTransport, boolean detailedErrorsEnabled) {
        this.serverTransport = serverTransport;
        this.corsPattern = RestUtils.checkCorsSettingForRegex(serverTransport.settings().get("http.cors.allow-origin"));
        this.httpPipeliningEnabled = serverTransport.pipelining;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpRequest request;
        OrderedUpstreamMessageEvent oue = null;
        if (this.httpPipeliningEnabled && e instanceof OrderedUpstreamMessageEvent) {
            oue = (OrderedUpstreamMessageEvent)e;
            request = (HttpRequest)oue.getMessage();
        } else {
            request = (HttpRequest)e.getMessage();
        }
        NettyHttpRequest httpRequest = new NettyHttpRequest(request, e.getChannel());
        if (oue != null) {
            this.serverTransport.dispatchRequest(httpRequest, new NettyHttpChannel(this.serverTransport, httpRequest, this.corsPattern, oue, this.detailedErrorsEnabled));
        } else {
            this.serverTransport.dispatchRequest(httpRequest, new NettyHttpChannel(this.serverTransport, httpRequest, this.corsPattern, this.detailedErrorsEnabled));
        }
        super.messageReceived(ctx, e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.serverTransport.exceptionCaught(ctx, e);
    }
}

