/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractGeoPointDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.BytesBinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DisabledIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FloatArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.IndexIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PackedArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;

public class IndexFieldDataService
extends AbstractIndexComponent {
    public static final String FIELDDATA_CACHE_KEY = "index.fielddata.cache";
    public static final String FIELDDATA_CACHE_VALUE_NODE = "node";
    private static final String DISABLED_FORMAT = "disabled";
    private static final String DOC_VALUES_FORMAT = "doc_values";
    private static final String ARRAY_FORMAT = "array";
    private static final String PAGED_BYTES_FORMAT = "paged_bytes";
    private static final ImmutableMap<String, IndexFieldData.Builder> buildersByType = MapBuilder.newMapBuilder().put("string", new PagedBytesIndexFieldData.Builder()).put("float", (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put("double", (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put("byte", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put("short", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put("int", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put("long", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put("geo_point", (PagedBytesIndexFieldData.Builder)((Object)new GeoPointArrayIndexFieldData.Builder())).put("_parent", (PagedBytesIndexFieldData.Builder)((Object)new ParentChildIndexFieldData.Builder())).put("_index", (PagedBytesIndexFieldData.Builder)((Object)new IndexIndexFieldData.Builder())).put("binary", (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put("boolean", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BOOLEAN))).immutableMap();
    private static final ImmutableMap<String, IndexFieldData.Builder> docValuesBuildersByType = MapBuilder.newMapBuilder().put("string", new DocValuesIndexFieldData.Builder()).put("float", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT)).put("double", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.DOUBLE)).put("byte", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BYTE)).put("short", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.SHORT)).put("int", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.INT)).put("long", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG)).put("geo_point", (DocValuesIndexFieldData.Builder)((Object)new AbstractGeoPointDVIndexFieldData.Builder())).put("binary", (DocValuesIndexFieldData.Builder)((Object)new BytesBinaryDVIndexFieldData.Builder())).put("boolean", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BOOLEAN)).immutableMap();
    private static final ImmutableMap<Tuple<String, String>, IndexFieldData.Builder> buildersByTypeAndFormat = MapBuilder.newMapBuilder().put(Tuple.tuple("string", "paged_bytes"), new PagedBytesIndexFieldData.Builder()).put(Tuple.tuple("string", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder())).put(Tuple.tuple("string", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("float", "array"), (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put(Tuple.tuple("float", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT))).put(Tuple.tuple("float", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("double", "array"), (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("double", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.DOUBLE))).put(Tuple.tuple("double", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("byte", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("short", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("int", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("long", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "array"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointArrayIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new AbstractGeoPointDVIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("binary", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new BytesBinaryDVIndexFieldData.Builder())).put(Tuple.tuple("binary", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("boolean", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BOOLEAN))).put(Tuple.tuple("boolean", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BOOLEAN))).put(Tuple.tuple("boolean", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).immutableMap();
    private final CircuitBreakerService circuitBreakerService;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final Map<String, IndexFieldDataCache> fieldDataCaches = Maps.newHashMap();
    private final MapperService mapperService;
    private static final IndexFieldDataCache.Listener DEFAULT_NOOP_LISTENER = new IndexFieldDataCache.Listener(){

        @Override
        public void onCache(ShardId shardId, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, Accountable ramUsage) {
        }

        @Override
        public void onRemoval(ShardId shardId, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes) {
        }
    };
    private volatile IndexFieldDataCache.Listener listener = DEFAULT_NOOP_LISTENER;
    private IndexFieldData<?> parentIndexFieldData;

    @Inject
    public IndexFieldDataService(Index index, IndexSettingsService indexSettingsService, IndicesFieldDataCache indicesFieldDataCache, CircuitBreakerService circuitBreakerService, MapperService mapperService) {
        super(index, indexSettingsService.getSettings());
        this.indicesFieldDataCache = indicesFieldDataCache;
        this.circuitBreakerService = circuitBreakerService;
        this.mapperService = mapperService;
    }

    public synchronized void clear() {
        this.parentIndexFieldData = null;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(0);
        Collection<IndexFieldDataCache> fieldDataCacheValues = this.fieldDataCaches.values();
        for (IndexFieldDataCache cache : fieldDataCacheValues) {
            try {
                cache.clear();
            }
            catch (Throwable t) {
                exceptions.add(t);
            }
        }
        fieldDataCacheValues.clear();
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    public synchronized void clearField(String fieldName) {
        if ("_parent".equals(fieldName)) {
            this.parentIndexFieldData = null;
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(0);
        IndexFieldDataCache cache = this.fieldDataCaches.remove(fieldName);
        if (cache != null) {
            try {
                cache.clear();
            }
            catch (Throwable t) {
                exceptions.add(t);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        IndexFieldDataCache cache;
        MappedFieldType.Names fieldNames = fieldType.names();
        FieldDataType type = fieldType.fieldDataType();
        if (type == null) {
            throw new IllegalArgumentException("found no fielddata type for field [" + fieldNames.fullName() + "]");
        }
        boolean docValues = fieldType.hasDocValues();
        IndexFieldData.Builder builder = null;
        Settings indexSettings = this.indexSettings();
        String format = type.getFormat(indexSettings);
        if (format != null && DOC_VALUES_FORMAT.equals(format) && !docValues) {
            this.logger.warn("field [" + fieldNames.fullName() + "] has no doc values, will use default field data format", new Object[0]);
            format = null;
        }
        if (format != null && (builder = buildersByTypeAndFormat.get(Tuple.tuple(type.getType(), format))) == null) {
            this.logger.warn("failed to find format [" + format + "] for field [" + fieldNames.fullName() + "], will use default", new Object[0]);
        }
        if (builder == null && docValues) {
            builder = docValuesBuildersByType.get(type.getType());
        }
        if (builder == null) {
            builder = buildersByType.get(type.getType());
        }
        if (builder == null) {
            throw new IllegalArgumentException("failed to find field data builder for field " + fieldNames.fullName() + ", and type " + type.getType());
        }
        IndexFieldDataService indexFieldDataService = this;
        synchronized (indexFieldDataService) {
            boolean isOldParentField;
            cache = this.fieldDataCaches.get(fieldNames.indexName());
            if (cache == null) {
                String cacheType = type.getSettings().get("cache", indexSettings.get(FIELDDATA_CACHE_KEY, FIELDDATA_CACHE_VALUE_NODE));
                if (FIELDDATA_CACHE_VALUE_NODE.equals(cacheType)) {
                    cache = this.indicesFieldDataCache.buildIndexFieldDataCache(this.listener, this.index, fieldNames, type);
                } else if ("none".equals(cacheType)) {
                    cache = new IndexFieldDataCache.None();
                } else {
                    throw new IllegalArgumentException("cache type not supported [" + cacheType + "] for field [" + fieldNames.fullName() + "]");
                }
                this.fieldDataCaches.put(fieldNames.indexName(), cache);
            }
            boolean bl = isOldParentField = "_parent".equals(fieldNames.indexName()) && Version.indexCreated(indexSettings).before(Version.V_2_0_0_beta1);
            if (isOldParentField) {
                if (this.parentIndexFieldData == null) {
                    this.parentIndexFieldData = builder.build(this.index, indexSettings, fieldType, cache, this.circuitBreakerService, this.mapperService);
                }
                return (IFD)this.parentIndexFieldData;
            }
        }
        return (IFD)builder.build(this.index, indexSettings, fieldType, cache, this.circuitBreakerService, this.mapperService);
    }

    public void setListener(IndexFieldDataCache.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listener != DEFAULT_NOOP_LISTENER) {
            throw new IllegalStateException("can't set listener more than once");
        }
        this.listener = listener;
    }
}

